/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmanager.ExecutionPlanStore;
import org.apache.flink.runtime.jobmanager.JobPersistenceComponentFactory;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.SupplierWithException;

public class HaServicesJobPersistenceComponentFactory
implements JobPersistenceComponentFactory {
    private final HighAvailabilityServices highAvailabilityServices;

    public HaServicesJobPersistenceComponentFactory(HighAvailabilityServices highAvailabilityServices) {
        this.highAvailabilityServices = highAvailabilityServices;
    }

    @Override
    public ExecutionPlanStore createExecutionPlanStore() {
        return this.create(this.highAvailabilityServices::getExecutionPlanStore, ExecutionPlanStore.class);
    }

    @Override
    public JobResultStore createJobResultStore() {
        return this.create(this.highAvailabilityServices::getJobResultStore, JobResultStore.class);
    }

    private <T> T create(SupplierWithException<T, ? extends Exception> supplier, Class<T> clazz) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(String.format("Could not create %s from %s.", clazz.getSimpleName(), this.highAvailabilityServices.getClass().getSimpleName()), e);
        }
    }
}

