/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.Preconditions;

public class IntermediateDataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IntermediateDataSetID id;
    private final JobVertex producer;
    private final List<JobEdge> consumers = new ArrayList<JobEdge>();
    private final ResultPartitionType resultType;
    private DistributionPattern distributionPattern;
    private boolean isBroadcast;
    private boolean isForward;
    private int numJobEdgesToCreate;

    public IntermediateDataSet(IntermediateDataSetID id, ResultPartitionType resultType, JobVertex producer) {
        this.id = Preconditions.checkNotNull(id);
        this.producer = Preconditions.checkNotNull(producer);
        this.resultType = Preconditions.checkNotNull(resultType);
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public JobVertex getProducer() {
        return this.producer;
    }

    public List<JobEdge> getConsumers() {
        return this.consumers;
    }

    public boolean areAllConsumerVerticesCreated() {
        return this.numJobEdgesToCreate == this.consumers.size();
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public DistributionPattern getDistributionPattern() {
        return this.distributionPattern;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    public void addConsumer(JobEdge edge) {
        Preconditions.checkState(this.id.equals(edge.getSourceId()), "Incompatible dataset id.");
        if (this.consumers.isEmpty() && this.distributionPattern == null) {
            this.distributionPattern = edge.getDistributionPattern();
            this.isBroadcast = edge.isBroadcast();
            this.isForward = edge.isForward();
        } else {
            Preconditions.checkState(this.distributionPattern == edge.getDistributionPattern(), "Incompatible distribution pattern.");
            Preconditions.checkState(this.isBroadcast == edge.isBroadcast(), "Incompatible broadcast type.");
            Preconditions.checkState(this.isForward == edge.isForward(), "Incompatible forward type.");
        }
        this.consumers.add(edge);
    }

    public void configure(DistributionPattern distributionPattern, boolean isBroadcast, boolean isForward) {
        Preconditions.checkState(this.consumers.isEmpty(), "The output job edges have already been added.");
        if (this.distributionPattern == null) {
            this.distributionPattern = distributionPattern;
            this.isBroadcast = isBroadcast;
            this.isForward = isForward;
        } else {
            Preconditions.checkState(this.distributionPattern == distributionPattern, "Incompatible distribution pattern.");
            Preconditions.checkState(this.isBroadcast == isBroadcast, "Incompatible broadcast type.");
            Preconditions.checkState(this.isForward == isForward, "Incompatible forward type.");
        }
    }

    public void updateOutputPattern(DistributionPattern distributionPattern, boolean isBroadcast, boolean isForward) {
        Preconditions.checkState(this.consumers.isEmpty(), "The output job edges have already been added.");
        Preconditions.checkState(this.numJobEdgesToCreate == 1, "Modification is not allowed when the subscribing output is reused.");
        this.distributionPattern = distributionPattern;
        this.isBroadcast = isBroadcast;
        this.isForward = isForward;
    }

    public void increaseNumJobEdgesToCreate() {
        ++this.numJobEdgesToCreate;
    }

    public String toString() {
        return "Intermediate Data Set (" + this.id + ")";
    }
}

