/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.common;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageDataIdentifier;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public abstract class TieredStorageBytesBasedDataIdentifier
implements TieredStorageDataIdentifier,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final byte[] bytes;
    protected final int hashCode;

    public TieredStorageBytesBasedDataIdentifier(byte[] bytes) {
        Preconditions.checkArgument(bytes != null, "Must be not null.");
        this.bytes = bytes;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TieredStorageBytesBasedDataIdentifier thatID = (TieredStorageBytesBasedDataIdentifier)that;
        return this.hashCode == thatID.hashCode && Arrays.equals(this.bytes, thatID.bytes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "TieredStorageBytesBasedDataIdentifier{ID=" + StringUtils.byteToHexString(this.bytes) + "}";
    }
}

