/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public abstract class InputChannel {
    protected final InputChannelInfo channelInfo;
    protected final ResultPartitionID partitionId;
    protected final ResultSubpartitionIndexSet consumedSubpartitionIndexSet;
    protected final SingleInputGate inputGate;
    private final AtomicReference<Throwable> cause = new AtomicReference();
    protected final int initialBackoff;
    protected final int maxBackoff;
    protected final Counter numBytesIn;
    protected final Counter numBuffersIn;
    private final int subpartitionId;
    protected int currentBackoff;

    protected InputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ResultSubpartitionIndexSet consumedSubpartitionIndexSet, int initialBackoff, int maxBackoff, Counter numBytesIn, Counter numBuffersIn) {
        Preconditions.checkArgument(channelIndex >= 0);
        int initial = initialBackoff;
        int max = maxBackoff;
        Preconditions.checkArgument(initial >= 0 && initial <= max);
        this.inputGate = Preconditions.checkNotNull(inputGate);
        this.channelInfo = new InputChannelInfo(inputGate.getGateIndex(), channelIndex);
        this.partitionId = Preconditions.checkNotNull(partitionId);
        this.consumedSubpartitionIndexSet = consumedSubpartitionIndexSet;
        this.subpartitionId = consumedSubpartitionIndexSet.size() > 1 ? -1 : consumedSubpartitionIndexSet.values().iterator().next();
        this.initialBackoff = initial;
        this.maxBackoff = max;
        this.currentBackoff = 0;
        this.numBytesIn = numBytesIn;
        this.numBuffersIn = numBuffersIn;
    }

    public int getChannelIndex() {
        return this.channelInfo.getInputChannelIdx();
    }

    public InputChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public ResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultSubpartitionIndexSet getConsumedSubpartitionIndexSet() {
        return this.consumedSubpartitionIndexSet;
    }

    public abstract void resumeConsumption() throws IOException;

    public abstract void acknowledgeAllRecordsProcessed() throws IOException;

    protected void notifyChannelNonEmpty() {
        this.inputGate.notifyChannelNonEmpty(this);
    }

    public void notifyPriorityEvent(int priorityBufferNumber) {
        this.inputGate.notifyPriorityEvent(this, priorityBufferNumber);
    }

    protected void notifyBufferAvailable(int numAvailableBuffers) throws IOException {
    }

    abstract void requestSubpartitions() throws IOException, InterruptedException;

    public int peekNextBufferSubpartitionId() throws IOException {
        if (this.subpartitionId >= 0) {
            return this.subpartitionId;
        }
        return this.peekNextBufferSubpartitionIdInternal();
    }

    protected abstract int peekNextBufferSubpartitionIdInternal() throws IOException;

    public abstract Optional<BufferAndAvailability> getNextBuffer() throws IOException, InterruptedException;

    public void checkpointStarted(CheckpointBarrier barrier) throws CheckpointException {
    }

    public void checkpointStopped(long checkpointId) {
    }

    public void convertToPriorityEvent(int sequenceNumber) throws IOException {
    }

    abstract void sendTaskEvent(TaskEvent var1) throws IOException;

    abstract boolean isReleased();

    abstract void releaseAllResources() throws IOException;

    abstract void announceBufferSize(int var1);

    abstract int getBuffersInUseCount();

    protected void checkError() throws IOException {
        Throwable t = this.cause.get();
        if (t != null) {
            if (t instanceof CancelTaskException) {
                throw (CancelTaskException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
    }

    protected void setError(Throwable cause) {
        if (this.cause.compareAndSet(null, Preconditions.checkNotNull(cause))) {
            this.notifyChannelNonEmpty();
        }
    }

    protected int getCurrentBackoff() {
        return this.currentBackoff <= 0 ? 0 : this.currentBackoff;
    }

    protected boolean increaseBackoff() {
        if (this.initialBackoff == 0) {
            return false;
        }
        if (this.currentBackoff == 0) {
            this.currentBackoff = this.initialBackoff;
            return true;
        }
        if (this.currentBackoff < this.maxBackoff) {
            this.currentBackoff = Math.min(this.currentBackoff * 2, this.maxBackoff);
            return true;
        }
        return false;
    }

    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return 0;
    }

    public long unsynchronizedGetSizeOfQueuedBuffers() {
        return 0L;
    }

    public void notifyRequiredSegmentId(int subpartitionId, int segmentId) throws IOException {
    }

    void setup() throws IOException {
    }

    public static final class BufferAndAvailability {
        private final Buffer buffer;
        private final Buffer.DataType nextDataType;
        private final int buffersInBacklog;
        private final int sequenceNumber;

        public BufferAndAvailability(Buffer buffer, Buffer.DataType nextDataType, int buffersInBacklog, int sequenceNumber) {
            this.buffer = Preconditions.checkNotNull(buffer);
            this.nextDataType = Preconditions.checkNotNull(nextDataType);
            this.buffersInBacklog = buffersInBacklog;
            this.sequenceNumber = sequenceNumber;
        }

        public Buffer buffer() {
            return this.buffer;
        }

        public boolean moreAvailable() {
            return this.nextDataType != Buffer.DataType.NONE;
        }

        public boolean morePriorityEvents() {
            return this.nextDataType.hasPriority();
        }

        public int buffersInBacklog() {
            return this.buffersInBacklog;
        }

        public boolean hasPriority() {
            return this.buffer.getDataType().hasPriority();
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String toString() {
            return "BufferAndAvailability{buffer=" + this.buffer + ", nextDataType=" + this.nextDataType + ", buffersInBacklog=" + this.buffersInBacklog + ", sequenceNumber=" + this.sequenceNumber + "}";
        }
    }
}

