/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.runtime.checkpoint.metadata.ChannelStateHandleSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV2V3SerializerBase;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.ChannelStateHelper;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.InputStateHandle;
import org.apache.flink.runtime.state.OutputStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.QuadFunction;

class ChannelStateHandleSerializerV1
implements ChannelStateHandleSerializer {
    ChannelStateHandleSerializerV1() {
    }

    @Override
    public void serialize(OutputStateHandle handle, DataOutputStream dos) throws IOException {
        if (!(handle instanceof ResultSubpartitionStateHandle)) {
            throw new IllegalStateException("OutputStateHandle must be ResultSubpartitionStateHandle.");
        }
        ChannelStateHandleSerializerV1.serializeChannelStateHandle((ResultSubpartitionStateHandle)handle, dos, ChannelStateHelper.RESULT_SUBPARTITION_INFO_WRITER);
    }

    @Override
    public OutputStateHandle deserializeOutputStateHandle(DataInputStream dis, MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        return ChannelStateHandleSerializerV1.deserializeChannelStateHandle(ChannelStateHelper.RESULT_SUBPARTITION_INFO_READER, ResultSubpartitionStateHandle::new, dis, context);
    }

    @Override
    public void serialize(InputStateHandle handle, DataOutputStream dos) throws IOException {
        if (!(handle instanceof InputChannelStateHandle)) {
            throw new IllegalStateException("InputStateHandle must be InputChannelStateHandle.");
        }
        ChannelStateHandleSerializerV1.serializeChannelStateHandle((InputChannelStateHandle)handle, dos, ChannelStateHelper.INPUT_CHANNEL_INFO_WRITER);
    }

    @Override
    public InputStateHandle deserializeInputStateHandle(DataInputStream dis, MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        return ChannelStateHandleSerializerV1.deserializeChannelStateHandle(ChannelStateHelper.INPUT_CHANNEL_INFO_READER, InputChannelStateHandle::new, dis, context);
    }

    static <Info> void serializeChannelStateHandle(AbstractChannelStateHandle<Info> handle, DataOutputStream dos, BiConsumerWithException<Info, DataOutputStream, IOException> infoWriter) throws IOException {
        dos.writeInt(handle.getSubtaskIndex());
        infoWriter.accept(handle.getInfo(), dos);
        dos.writeInt(handle.getOffsets().size());
        for (long offset : handle.getOffsets()) {
            dos.writeLong(offset);
        }
        dos.writeLong(handle.getStateSize());
        MetadataV2V3SerializerBase.serializeStreamStateHandle(handle.getDelegate(), dos);
    }

    static <Info, Handle extends AbstractChannelStateHandle<Info>> Handle deserializeChannelStateHandle(FunctionWithException<DataInputStream, Info, IOException> infoReader, QuadFunction<Integer, Info, StreamStateHandle, AbstractChannelStateHandle.StateContentMetaInfo, Handle> handleBuilder, DataInputStream dis, MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        int subtaskIndex = dis.readInt();
        Info info = infoReader.apply(dis);
        int offsetsSize = dis.readInt();
        ArrayList<Long> offsets = new ArrayList<Long>(offsetsSize);
        for (int i = 0; i < offsetsSize; ++i) {
            offsets.add(dis.readLong());
        }
        long size = dis.readLong();
        return (Handle)((AbstractChannelStateHandle)handleBuilder.apply(subtaskIndex, info, MetadataV2V3SerializerBase.deserializeStreamStateHandle(dis, context), new AbstractChannelStateHandle.StateContentMetaInfo(offsets, size)));
    }
}

