/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ResolvedCatalogMaterializedTable
implements ResolvedCatalogBaseTable<CatalogMaterializedTable>,
CatalogMaterializedTable {
    private final CatalogMaterializedTable origin;
    private final ResolvedSchema resolvedSchema;

    public ResolvedCatalogMaterializedTable(CatalogMaterializedTable origin, ResolvedSchema resolvedSchema) {
        this.origin = Preconditions.checkNotNull(origin, "Original catalog materialized table must not be null.");
        this.resolvedSchema = Preconditions.checkNotNull(resolvedSchema, "Resolved schema must not be null.");
    }

    @Override
    public Map<String, String> getOptions() {
        return this.origin.getOptions();
    }

    @Override
    public String getComment() {
        return this.origin.getComment();
    }

    @Override
    public CatalogBaseTable copy() {
        return new ResolvedCatalogMaterializedTable((CatalogMaterializedTable)this.origin.copy(), this.resolvedSchema);
    }

    @Override
    public ResolvedCatalogMaterializedTable copy(Map<String, String> options) {
        return new ResolvedCatalogMaterializedTable(this.origin.copy(options), this.resolvedSchema);
    }

    @Override
    public ResolvedCatalogMaterializedTable copy(CatalogMaterializedTable.RefreshStatus refreshStatus, String refreshHandlerDescription, byte[] serializedRefreshHandler) {
        return new ResolvedCatalogMaterializedTable(this.origin.copy(refreshStatus, refreshHandlerDescription, serializedRefreshHandler), this.resolvedSchema);
    }

    @Override
    public Optional<String> getDescription() {
        return this.origin.getDescription();
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return this.origin.getDetailedDescription();
    }

    @Override
    public boolean isPartitioned() {
        return this.origin.isPartitioned();
    }

    @Override
    public List<String> getPartitionKeys() {
        return this.origin.getPartitionKeys();
    }

    @Override
    public Optional<Long> getSnapshot() {
        return this.origin.getSnapshot();
    }

    @Override
    public CatalogMaterializedTable getOrigin() {
        return this.origin;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String getDefinitionQuery() {
        return this.origin.getDefinitionQuery();
    }

    @Override
    public IntervalFreshness getDefinitionFreshness() {
        return this.origin.getDefinitionFreshness();
    }

    @Override
    public CatalogMaterializedTable.LogicalRefreshMode getLogicalRefreshMode() {
        return this.origin.getLogicalRefreshMode();
    }

    @Override
    public CatalogMaterializedTable.RefreshMode getRefreshMode() {
        return this.origin.getRefreshMode();
    }

    @Override
    public CatalogMaterializedTable.RefreshStatus getRefreshStatus() {
        return this.origin.getRefreshStatus();
    }

    @Override
    public Optional<String> getRefreshHandlerDescription() {
        return this.origin.getRefreshHandlerDescription();
    }

    @Override
    @Nullable
    public byte[] getSerializedRefreshHandler() {
        return this.origin.getSerializedRefreshHandler();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedCatalogMaterializedTable that = (ResolvedCatalogMaterializedTable)o;
        return Objects.equals(this.origin, that.origin) && Objects.equals(this.resolvedSchema, that.resolvedSchema);
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.resolvedSchema);
    }

    public String toString() {
        return "ResolvedCatalogMaterializedTable{origin=" + this.origin + ", resolvedSchema=" + this.resolvedSchema + "}";
    }

    public ResolvedCatalogTable toResolvedCatalogTable() {
        return new ResolvedCatalogTable(CatalogTable.newBuilder().schema(this.getUnresolvedSchema()).comment(this.getComment()).partitionKeys(this.getPartitionKeys()).options(this.getOptions()).snapshot(this.getSnapshot().orElse(null)).build(), this.getResolvedSchema());
    }
}

