/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;

public class SlotAllocationSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SlotID slotID;
    private final JobID jobId;
    private final String jobTargetAddress;
    private final AllocationID allocationId;
    private final ResourceProfile resourceProfile;

    public SlotAllocationSnapshot(SlotID slotID, JobID jobId, String jobTargetAddress, AllocationID allocationId, ResourceProfile resourceProfile) {
        this.slotID = slotID;
        this.jobId = jobId;
        this.jobTargetAddress = jobTargetAddress;
        this.allocationId = allocationId;
        this.resourceProfile = resourceProfile;
    }

    public SlotID getSlotID() {
        return this.slotID;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getJobTargetAddress() {
        return this.jobTargetAddress;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public int getSlotIndex() {
        return this.slotID.getSlotNumber();
    }

    public String toString() {
        return "SlotAllocationSnapshot{slotID=" + this.slotID + ", jobId=" + this.jobId + ", jobTargetAddress='" + this.jobTargetAddress + "', allocationId=" + this.allocationId + ", resourceProfile=" + this.resourceProfile + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotAllocationSnapshot that = (SlotAllocationSnapshot)o;
        return this.slotID.equals(that.slotID) && this.jobId.equals(that.jobId) && this.jobTargetAddress.equals(that.jobTargetAddress) && this.allocationId.equals(that.allocationId) && this.resourceProfile.equals(that.resourceProfile);
    }

    public int hashCode() {
        return Objects.hash(this.slotID, this.jobId, this.jobTargetAddress, this.allocationId, this.resourceProfile);
    }
}

