/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.MapSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializerSnapshot;
import org.apache.flink.util.Preconditions;

public class TtlAwareSerializerSnapshotWrapper<T> {
    private final StateDescriptor.Type stateType;
    private final TypeSerializerSnapshot<T> typeSerializerSnapshot;
    private final Map<StateDescriptor.Type, Supplier<TypeSerializerSnapshot<T>>> ttlAwareSerializerSnapshotFactories;

    public TtlAwareSerializerSnapshotWrapper(@Nonnull StateMetaInfoSnapshot snapshot) {
        this.stateType = StateDescriptor.Type.valueOf(snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE));
        this.typeSerializerSnapshot = Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER));
        this.ttlAwareSerializerSnapshotFactories = this.createTtlAwareSerializerSnapshotFactories();
    }

    @VisibleForTesting
    public TtlAwareSerializerSnapshotWrapper(StateDescriptor.Type stateType, TypeSerializerSnapshot<T> typeSerializerSnapshot) {
        this.stateType = stateType;
        this.typeSerializerSnapshot = typeSerializerSnapshot;
        this.ttlAwareSerializerSnapshotFactories = this.createTtlAwareSerializerSnapshotFactories();
    }

    private Map<StateDescriptor.Type, Supplier<TypeSerializerSnapshot<T>>> createTtlAwareSerializerSnapshotFactories() {
        return Stream.of(Tuple2.of(StateDescriptor.Type.VALUE, this::wrapValueSerializerSnapshot), Tuple2.of(StateDescriptor.Type.LIST, this::wrapListSerializerSnapshot), Tuple2.of(StateDescriptor.Type.MAP, this::wrapMapSerializerSnapshot), Tuple2.of(StateDescriptor.Type.REDUCING, this::wrapValueSerializerSnapshot), Tuple2.of(StateDescriptor.Type.AGGREGATING, this::wrapValueSerializerSnapshot)).collect(Collectors.toMap(t -> (StateDescriptor.Type)((Object)((Object)t.f0)), t -> (Supplier)t.f1));
    }

    public TypeSerializerSnapshot<T> getTtlAwareSerializerSnapshot() {
        return this.ttlAwareSerializerSnapshotFactories.get((Object)this.stateType).get();
    }

    private TypeSerializerSnapshot<T> wrapValueSerializerSnapshot() {
        return this.typeSerializerSnapshot instanceof TtlAwareSerializerSnapshot ? this.typeSerializerSnapshot : new TtlAwareSerializerSnapshot<T>(this.typeSerializerSnapshot);
    }

    private TypeSerializerSnapshot<T> wrapListSerializerSnapshot() {
        ListSerializerSnapshot listSerializerSnapshot = (ListSerializerSnapshot)this.typeSerializerSnapshot;
        if (!(listSerializerSnapshot.getElementSerializerSnapshot() instanceof TtlAwareSerializerSnapshot)) {
            CompositeTypeSerializerUtil.setNestedSerializersSnapshots(listSerializerSnapshot, new TtlAwareSerializerSnapshot(listSerializerSnapshot.getElementSerializerSnapshot()));
        }
        return listSerializerSnapshot;
    }

    private TypeSerializerSnapshot<T> wrapMapSerializerSnapshot() {
        MapSerializerSnapshot mapSerializerSnapshot = (MapSerializerSnapshot)this.typeSerializerSnapshot;
        if (!(mapSerializerSnapshot.getValueSerializerSnapshot() instanceof TtlAwareSerializerSnapshot)) {
            CompositeTypeSerializerUtil.setNestedSerializersSnapshots(mapSerializerSnapshot, mapSerializerSnapshot.getKeySerializerSnapshot(), new TtlAwareSerializerSnapshot(mapSerializerSnapshot.getValueSerializerSnapshot()));
        }
        return mapSerializerSnapshot;
    }
}

