/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializerSnapshot;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.function.SupplierWithException;

public class TtlAwareSerializer<T>
extends TypeSerializer<T> {
    private final boolean isTtlEnabled;
    private final TypeSerializer<T> typeSerializer;

    public TtlAwareSerializer(TypeSerializer<T> typeSerializer) {
        this.typeSerializer = typeSerializer;
        this.isTtlEnabled = typeSerializer instanceof TtlStateFactory.TtlSerializer;
    }

    @Override
    public boolean isImmutableType() {
        return this.typeSerializer.isImmutableType();
    }

    @Override
    public TypeSerializer<T> duplicate() {
        return new TtlAwareSerializer<T>(this.typeSerializer.duplicate());
    }

    @Override
    public T createInstance() {
        return this.typeSerializer.createInstance();
    }

    @Override
    public T copy(T from) {
        return this.typeSerializer.copy(from);
    }

    @Override
    public T copy(T from, T reuse) {
        return this.typeSerializer.copy(from, reuse);
    }

    @Override
    public int getLength() {
        return this.typeSerializer.getLength();
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        this.typeSerializer.serialize(record, target);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return this.typeSerializer.deserialize(source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.typeSerializer.deserialize(reuse, source);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TtlAwareSerializer that = (TtlAwareSerializer)o;
        return this.isTtlEnabled == that.isTtlEnabled && Objects.equals(this.typeSerializer, that.typeSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isTtlEnabled, this.typeSerializer);
    }

    public void migrateValueFromPriorSerializer(TtlAwareSerializer<T> priorTtlAwareSerializer, SupplierWithException<T, IOException> inputSupplier, DataOutputView target, TtlTimeProvider ttlTimeProvider) throws IOException {
        Object outputRecord = this.isTtlEnabled() ? (priorTtlAwareSerializer.isTtlEnabled ? inputSupplier.get() : new TtlValue<T>(inputSupplier.get(), ttlTimeProvider.currentTimestamp())) : (priorTtlAwareSerializer.isTtlEnabled ? ((TtlValue)inputSupplier.get()).getUserValue() : inputSupplier.get());
        this.serialize(outputRecord, target);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.typeSerializer.copy(source, target);
    }

    public boolean isTtlEnabled() {
        return this.isTtlEnabled;
    }

    public TypeSerializer<T> getOriginalTypeSerializer() {
        return this.typeSerializer;
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new TtlAwareSerializerSnapshot<T>(this.typeSerializer.snapshotConfiguration(), this.isTtlEnabled);
    }

    public static boolean isSerializerTtlEnabled(TypeSerializer<?> typeSerializer) {
        TypeSerializer<?> wrappedTypeSerializer = TtlAwareSerializer.wrapTtlAwareSerializer(typeSerializer);
        boolean ttlSerializer = wrappedTypeSerializer instanceof TtlAwareSerializer && ((TtlAwareSerializer)wrappedTypeSerializer).isTtlEnabled();
        boolean ttlListSerializer = wrappedTypeSerializer instanceof ListSerializer && ((ListSerializer)wrappedTypeSerializer).getElementSerializer() instanceof TtlAwareSerializer && ((TtlAwareSerializer)((ListSerializer)wrappedTypeSerializer).getElementSerializer()).isTtlEnabled();
        boolean ttlMapSerializer = wrappedTypeSerializer instanceof MapSerializer && ((MapSerializer)wrappedTypeSerializer).getValueSerializer() instanceof TtlAwareSerializer && ((TtlAwareSerializer)((MapSerializer)wrappedTypeSerializer).getValueSerializer()).isTtlEnabled();
        return ttlSerializer || ttlListSerializer || ttlMapSerializer;
    }

    public static TypeSerializer<?> wrapTtlAwareSerializer(TypeSerializer<?> typeSerializer) {
        if (typeSerializer instanceof TtlAwareSerializer) {
            return typeSerializer;
        }
        if (typeSerializer instanceof ListSerializer) {
            return ((ListSerializer)typeSerializer).getElementSerializer() instanceof TtlAwareSerializer ? typeSerializer : new ListSerializer(new TtlAwareSerializer(typeSerializer.getElementSerializer()));
        }
        if (typeSerializer instanceof MapSerializer) {
            return ((MapSerializer)((Object)typeSerializer)).getValueSerializer() instanceof TtlAwareSerializer ? typeSerializer : new MapSerializer(((MapSerializer)((Object)typeSerializer)).getKeySerializer(), new TtlAwareSerializer(((MapSerializer)((Object)typeSerializer)).getValueSerializer()));
        }
        return new TtlAwareSerializer(typeSerializer);
    }
}

