/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class JobExceptionsInfoWithHistory
implements ResponseBody {
    public static final String FIELD_NAME_EXCEPTION_HISTORY = "exceptionHistory";
    @JsonProperty(value="exceptionHistory")
    private final JobExceptionHistory exceptionHistory;

    @JsonCreator
    public JobExceptionsInfoWithHistory(@JsonProperty(value="exceptionHistory") JobExceptionHistory exceptionHistory) {
        this.exceptionHistory = exceptionHistory;
    }

    @JsonIgnore
    public JobExceptionHistory getExceptionHistory() {
        return this.exceptionHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobExceptionsInfoWithHistory that = (JobExceptionsInfoWithHistory)o;
        return Objects.equals(this.exceptionHistory, that.exceptionHistory);
    }

    public int hashCode() {
        return Objects.hash(this.exceptionHistory);
    }

    public String toString() {
        return new StringJoiner(", ", JobExceptionsInfoWithHistory.class.getSimpleName() + "[", "]").add("exceptionHistory=" + this.exceptionHistory).toString();
    }

    public static class RootExceptionInfo
    extends ExceptionInfo {
        public static final String FIELD_NAME_CONCURRENT_EXCEPTIONS = "concurrentExceptions";
        @JsonProperty(value="concurrentExceptions")
        private final Collection<ExceptionInfo> concurrentExceptions;

        public RootExceptionInfo(String exceptionName, String stacktrace, long timestamp, Map<String, String> failureLabels, Collection<ExceptionInfo> concurrentExceptions) {
            this(exceptionName, stacktrace, timestamp, failureLabels, null, null, null, concurrentExceptions);
        }

        @JsonCreator
        public RootExceptionInfo(@JsonProperty(value="exceptionName") String exceptionName, @JsonProperty(value="stacktrace") String stacktrace, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="failureLabels") Map<String, String> failureLabels, @JsonProperty(value="taskName") @Nullable String taskName, @JsonProperty(value="endpoint") @Nullable String endpoint, @JsonProperty(value="taskManagerId") @Nullable String taskManagerId, @JsonProperty(value="concurrentExceptions") Collection<ExceptionInfo> concurrentExceptions) {
            super(exceptionName, stacktrace, timestamp, failureLabels, taskName, endpoint, taskManagerId);
            this.concurrentExceptions = concurrentExceptions;
        }

        @JsonIgnore
        public Collection<ExceptionInfo> getConcurrentExceptions() {
            return this.concurrentExceptions;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            RootExceptionInfo that = (RootExceptionInfo)o;
            return this.getConcurrentExceptions().equals(that.getConcurrentExceptions());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getConcurrentExceptions());
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", RootExceptionInfo.class.getSimpleName() + "[", "]").add("exceptionName='" + this.getExceptionName() + "'").add("stacktrace='" + this.getStacktrace() + "'").add("timestamp=" + this.getTimestamp()).add("taskName='" + this.getTaskName() + "'").add("endpoint='" + this.getEndpoint() + "'").add("concurrentExceptions=" + this.getConcurrentExceptions()).toString();
        }
    }

    public static class ExceptionInfo {
        public static final String FIELD_NAME_EXCEPTION_NAME = "exceptionName";
        public static final String FIELD_NAME_EXCEPTION_STACKTRACE = "stacktrace";
        public static final String FIELD_NAME_EXCEPTION_TIMESTAMP = "timestamp";
        public static final String FIELD_NAME_TASK_NAME = "taskName";
        public static final String FIELD_NAME_ENDPOINT = "endpoint";
        public static final String FIELD_NAME_TASK_MANAGER_ID = "taskManagerId";
        public static final String FIELD_NAME_FAILURE_LABELS = "failureLabels";
        @JsonProperty(value="exceptionName")
        private final String exceptionName;
        @JsonProperty(value="stacktrace")
        private final String stacktrace;
        @JsonProperty(value="timestamp")
        private final long timestamp;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="taskName")
        @Nullable
        private final String taskName;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="endpoint")
        @Nullable
        private final String endpoint;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="taskManagerId")
        @Nullable
        private final String taskManagerId;
        @JsonProperty(value="failureLabels")
        private final Map<String, String> failureLabels;

        public ExceptionInfo(String exceptionName, String stacktrace, long timestamp) {
            this(exceptionName, stacktrace, timestamp, Collections.emptyMap(), null, null, null);
        }

        @JsonCreator
        public ExceptionInfo(@JsonProperty(value="exceptionName") String exceptionName, @JsonProperty(value="stacktrace") String stacktrace, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="failureLabels") Map<String, String> failureLabels, @JsonProperty(value="taskName") @Nullable String taskName, @JsonProperty(value="endpoint") @Nullable String endpoint, @JsonProperty(value="taskManagerId") @Nullable String taskManagerId) {
            this.exceptionName = Preconditions.checkNotNull(exceptionName);
            this.stacktrace = Preconditions.checkNotNull(stacktrace);
            this.timestamp = timestamp;
            this.failureLabels = Preconditions.checkNotNull(failureLabels);
            this.taskName = taskName;
            this.endpoint = endpoint;
            this.taskManagerId = taskManagerId;
        }

        @JsonIgnore
        public String getExceptionName() {
            return this.exceptionName;
        }

        @JsonIgnore
        public String getStacktrace() {
            return this.stacktrace;
        }

        @JsonIgnore
        public long getTimestamp() {
            return this.timestamp;
        }

        @JsonIgnore
        @Nullable
        public String getTaskName() {
            return this.taskName;
        }

        @JsonIgnore
        @Nullable
        public String getEndpoint() {
            return this.endpoint;
        }

        @JsonIgnore
        @Nullable
        public String getTaskManagerId() {
            return this.taskManagerId;
        }

        @JsonIgnore
        public Map<String, String> getFailureLabels() {
            return this.failureLabels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExceptionInfo that = (ExceptionInfo)o;
            return this.exceptionName.equals(that.exceptionName) && this.stacktrace.equals(that.stacktrace) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.failureLabels, that.failureLabels) && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.endpoint, that.endpoint);
        }

        public int hashCode() {
            return Objects.hash(this.exceptionName, this.stacktrace, this.timestamp, this.failureLabels, this.taskName, this.endpoint);
        }

        public String toString() {
            return new StringJoiner(", ", ExceptionInfo.class.getSimpleName() + "[", "]").add("exceptionName='" + this.exceptionName + "'").add("stacktrace='" + this.stacktrace + "'").add("timestamp=" + this.timestamp).add("failureLabels=" + this.failureLabels).add("taskName='" + this.taskName + "'").add("endpoint='" + this.endpoint + "'").toString();
        }
    }

    public static final class JobExceptionHistory {
        public static final String FIELD_NAME_ENTRIES = "entries";
        public static final String FIELD_NAME_TRUNCATED = "truncated";
        @JsonProperty(value="entries")
        private final List<RootExceptionInfo> entries;
        @JsonProperty(value="truncated")
        private final boolean truncated;

        @JsonCreator
        public JobExceptionHistory(@JsonProperty(value="entries") List<RootExceptionInfo> entries, @JsonProperty(value="truncated") boolean truncated) {
            this.entries = entries;
            this.truncated = truncated;
        }

        @JsonIgnore
        public List<RootExceptionInfo> getEntries() {
            return this.entries;
        }

        @JsonIgnore
        public boolean isTruncated() {
            return this.truncated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobExceptionHistory that = (JobExceptionHistory)o;
            return this.isTruncated() == that.isTruncated() && Objects.equals(this.entries, that.entries);
        }

        public int hashCode() {
            return Objects.hash(this.entries, this.truncated);
        }

        public String toString() {
            return new StringJoiner(", ", JobExceptionHistory.class.getSimpleName() + "[", "]").add("entries=" + this.entries).add("truncated=" + this.truncated).toString();
        }
    }
}

