/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.LogListInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.concurrent.FutureUtils;

public class JobManagerLogListHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, LogListInfo, EmptyMessageParameters> {
    private final File logDir;

    public JobManagerLogListHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, LogListInfo, EmptyMessageParameters> messageHeaders, @Nullable File logDir) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.logDir = logDir;
    }

    @Override
    protected CompletableFuture<LogListInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        if (this.logDir == null) {
            return CompletableFuture.completedFuture(new LogListInfo(Collections.emptyList()));
        }
        File[] logFiles = this.logDir.listFiles();
        if (logFiles == null) {
            return FutureUtils.completedExceptionally(new IOException("Could not list files in " + this.logDir));
        }
        List<LogInfo> logs = Arrays.stream(logFiles).filter(File::isFile).map(logFile -> new LogInfo(logFile.getName(), logFile.length(), logFile.lastModified())).collect(Collectors.toList());
        return CompletableFuture.completedFuture(new LogListInfo(logs));
    }
}

