/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.io.File;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.AbstractHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.FlinkException;

public abstract class AbstractJobManagerFileHandler<M extends MessageParameters>
extends AbstractHandler<RestfulGateway, EmptyRequestBody, M> {
    protected AbstractJobManagerFileHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, UntypedResponseMessageHeaders<EmptyRequestBody, M> messageHeaders) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<Void> respondToRequest(ChannelHandlerContext ctx, HttpRequest httpRequest, HandlerRequest<EmptyRequestBody> handlerRequest, RestfulGateway gateway) {
        File file = this.getFile(handlerRequest);
        if (file != null && file.exists()) {
            try {
                HandlerUtils.transferFile(ctx, file, httpRequest);
            }
            catch (FlinkException e) {
                throw new CompletionException(new FlinkException("Could not transfer file to client.", e));
            }
            return CompletableFuture.completedFuture(null);
        }
        return HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody("This file does not exist in JobManager log dir."), HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
    }

    @Nullable
    protected abstract File getFile(HandlerRequest<EmptyRequestBody> var1);
}

