/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.entrypoint.component.AbstractUserClassPathJobGraphRetriever;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class FileJobGraphRetriever
extends AbstractUserClassPathJobGraphRetriever {
    @Internal
    public static final ConfigOption<String> JOB_GRAPH_FILE_PATH = ConfigOptions.key("internal.jobgraph-path").stringType().defaultValue("job.graph");
    @Nonnull
    private final String jobGraphFile;

    public FileJobGraphRetriever(@Nonnull String jobGraphFile, @Nullable File usrLibDir) throws IOException {
        super(usrLibDir);
        this.jobGraphFile = jobGraphFile;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobGraph retrieveJobGraph(Configuration configuration) throws FlinkException {
        File fp = new File(this.jobGraphFile);
        try (FileInputStream input = new FileInputStream(fp);){
            JobGraph jobGraph;
            try (ObjectInputStream obInput = new ObjectInputStream(input);){
                JobGraph jobGraph2 = (JobGraph)obInput.readObject();
                this.addUserClassPathsToJobGraph(jobGraph2);
                jobGraph = jobGraph2;
            }
            return jobGraph;
        }
        catch (FileNotFoundException e) {
            throw new FlinkException("Could not find the JobGraph file.", e);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FlinkException("Could not load the JobGraph from file.", e);
        }
    }

    private void addUserClassPathsToJobGraph(JobGraph jobGraph) {
        ArrayList<URL> classPaths = new ArrayList<URL>();
        if (jobGraph.getClasspaths() != null) {
            classPaths.addAll(jobGraph.getClasspaths());
        }
        classPaths.addAll(this.getUserClassPaths());
        jobGraph.setClasspaths(classPaths);
    }

    public static FileJobGraphRetriever createFrom(Configuration configuration, @Nullable File usrLibDir) throws IOException {
        Preconditions.checkNotNull(configuration, "configuration");
        return new FileJobGraphRetriever(configuration.get(JOB_GRAPH_FILE_PATH), usrLibDir);
    }
}

