/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.materializedtable;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableOperation;

@Internal
public class AlterMaterializedTableResumeOperation
extends AlterMaterializedTableOperation {
    private final Map<String, String> dynamicOptions;

    public AlterMaterializedTableResumeOperation(ObjectIdentifier tableIdentifier, Map<String, String> options) {
        super(tableIdentifier);
        this.dynamicOptions = options;
    }

    public Map<String, String> getDynamicOptions() {
        return this.dynamicOptions;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        throw new UnsupportedOperationException("AlterMaterializedTableResumeOperation doesn't support ExecutableOperation yet.");
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder(String.format("ALTER MATERIALIZED TABLE %s RESUME", this.tableIdentifier.asSummaryString()));
        if (!this.dynamicOptions.isEmpty()) {
            builder.append(String.format(" WITH (%s)", OperationUtils.formatProperties(this.dynamicOptions)));
        }
        return builder.toString();
    }
}

