/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.context;

import java.util.Optional;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;

public class EnvironmentReusableInMemoryCatalog
extends GenericInMemoryCatalog {
    public EnvironmentReusableInMemoryCatalog(String name, String defaultDatabase) {
        super(name, defaultDatabase);
    }

    @Override
    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException {
        CatalogBaseTable tableToRegister = this.extractView(table).flatMap(QueryOperationCatalogView::getOriginalView).map(v -> v).orElse(table);
        super.createTable(tablePath, tableToRegister, ignoreIfExists);
    }

    private Optional<QueryOperationCatalogView> extractView(CatalogBaseTable table) {
        if (table instanceof ResolvedCatalogView) {
            CatalogView origin = ((ResolvedCatalogView)table).getOrigin();
            if (origin instanceof QueryOperationCatalogView) {
                return Optional.of((QueryOperationCatalogView)origin);
            }
            return Optional.empty();
        }
        if (table instanceof QueryOperationCatalogView) {
            return Optional.of((QueryOperationCatalogView)table);
        }
        return Optional.empty();
    }
}

