/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source.lookup.cache;

import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.metrics.groups.CacheMetricGroup;
import org.apache.flink.shaded.guava32.com.google.common.base.Ticker;
import org.apache.flink.shaded.guava32.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava32.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;

@PublicEvolving
public class DefaultLookupCache
implements LookupCache {
    private static final long serialVersionUID = 1L;
    private final Duration expireAfterAccessDuration;
    private final Duration expireAfterWriteDuration;
    private final Long maximumSize;
    private final boolean cacheMissingKey;
    private transient Cache<RowData, Collection<RowData>> guavaCache;
    private transient Ticker ticker;
    private transient Counter hitCounter;
    private transient Counter missCounter;

    private DefaultLookupCache(Duration expireAfterAccessDuration, Duration expireAfterWriteDuration, Long maximumSize, boolean cacheMissingKey) {
        this.expireAfterAccessDuration = expireAfterAccessDuration;
        this.expireAfterWriteDuration = expireAfterWriteDuration;
        this.maximumSize = maximumSize;
        this.cacheMissingKey = cacheMissingKey;
        this.sanityCheck();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static DefaultLookupCache fromConfig(ReadableConfig config) {
        Preconditions.checkArgument(config.get(LookupOptions.CACHE_TYPE).equals((Object)LookupOptions.LookupCacheType.PARTIAL), "'%s' should be '%s' in order to build a default lookup cache", new Object[]{LookupOptions.CACHE_TYPE.key(), LookupOptions.LookupCacheType.PARTIAL});
        Preconditions.checkArgument(config.getOptional(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS).isPresent() || config.getOptional(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE).isPresent() || config.getOptional(LookupOptions.PARTIAL_CACHE_MAX_ROWS).isPresent(), "Missing '%s', '%s' or '%s' in the configuration. The cache will not have evictions under this configuration and could lead to potential memory issues as the cache size may grow indefinitely.", LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS.key(), LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE.key(), LookupOptions.PARTIAL_CACHE_MAX_ROWS.key());
        return new DefaultLookupCache(config.get(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS), config.get(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE), config.get(LookupOptions.PARTIAL_CACHE_MAX_ROWS), config.get(LookupOptions.PARTIAL_CACHE_CACHE_MISSING_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(CacheMetricGroup metricGroup) {
        DefaultLookupCache defaultLookupCache = this;
        synchronized (defaultLookupCache) {
            if (this.guavaCache == null) {
                CacheBuilder<Object, Object> guavaCacheBuilder = CacheBuilder.newBuilder();
                if (this.expireAfterAccessDuration != null) {
                    guavaCacheBuilder.expireAfterAccess(this.expireAfterAccessDuration);
                }
                if (this.expireAfterWriteDuration != null) {
                    guavaCacheBuilder.expireAfterWrite(this.expireAfterWriteDuration);
                }
                if (this.maximumSize != null) {
                    guavaCacheBuilder.maximumSize(this.maximumSize);
                }
                if (this.ticker != null) {
                    guavaCacheBuilder.ticker(this.ticker);
                }
                this.guavaCache = guavaCacheBuilder.build();
            }
            if (this.hitCounter == null) {
                this.hitCounter = new ThreadSafeSimpleCounter();
            }
            if (this.missCounter == null) {
                this.missCounter = new ThreadSafeSimpleCounter();
            }
        }
        metricGroup.hitCounter(this.hitCounter);
        metricGroup.missCounter(this.missCounter);
        metricGroup.numCachedRecordsGauge(this.guavaCache::size);
    }

    @Override
    @Nullable
    public Collection<RowData> getIfPresent(RowData key) {
        Collection<RowData> value = this.guavaCache.getIfPresent(key);
        if (value != null) {
            this.hitCounter.inc();
        } else {
            this.missCounter.inc();
        }
        return value;
    }

    @Override
    public Collection<RowData> put(RowData key, Collection<RowData> value) {
        Preconditions.checkNotNull(key, "Cannot put an entry with null key into the cache");
        Preconditions.checkNotNull(value, "Cannot put an entry with null value into the cache");
        if (!value.isEmpty() || this.cacheMissingKey) {
            this.guavaCache.put(key, value);
        }
        return value;
    }

    @Override
    public void invalidate(RowData key) {
        this.guavaCache.invalidate(key);
    }

    @Override
    public long size() {
        return this.guavaCache.size();
    }

    @Override
    public void close() throws Exception {
        if (this.guavaCache != null) {
            this.guavaCache.invalidateAll();
            this.guavaCache.cleanUp();
        }
    }

    @VisibleForTesting
    void withClock(final Clock clock) {
        this.ticker = new Ticker(){

            @Override
            public long read() {
                return clock.relativeTimeNanos();
            }
        };
    }

    @VisibleForTesting
    Duration getExpireAfterAccessDuration() {
        return this.expireAfterAccessDuration;
    }

    @VisibleForTesting
    Duration getExpireAfterWriteDuration() {
        return this.expireAfterWriteDuration;
    }

    @VisibleForTesting
    Long getMaximumSize() {
        return this.maximumSize;
    }

    @VisibleForTesting
    boolean isCacheMissingKey() {
        return this.cacheMissingKey;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultLookupCache)) {
            return false;
        }
        DefaultLookupCache that = (DefaultLookupCache)o;
        return Objects.equals(this.expireAfterWriteDuration, that.expireAfterWriteDuration) && Objects.equals(this.expireAfterAccessDuration, that.expireAfterAccessDuration) && Objects.equals(this.maximumSize, that.maximumSize) && Objects.equals(this.cacheMissingKey, that.cacheMissingKey);
    }

    public int hashCode() {
        return Objects.hash(this.expireAfterAccessDuration, this.expireAfterAccessDuration, this.maximumSize, this.cacheMissingKey);
    }

    private void sanityCheck() {
        if (this.expireAfterWriteDuration == null && this.expireAfterAccessDuration == null && this.maximumSize == null) {
            throw new IllegalArgumentException("Expiration duration and maximum size are not set for the cache. The cache will not have any eviction and could lead to potential memory issues as the cache size may grow infinitely.");
        }
    }

    @PublicEvolving
    public static class Builder {
        private Duration expireAfterAccessDuration;
        private Duration expireAfterWriteDuration;
        private Long maximumSize;
        private boolean cacheMissingKey = true;

        public Builder expireAfterAccess(Duration duration) {
            this.expireAfterAccessDuration = duration;
            return this;
        }

        public Builder expireAfterWrite(Duration duration) {
            this.expireAfterWriteDuration = duration;
            return this;
        }

        public Builder maximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public Builder cacheMissingKey(boolean cacheMissingKey) {
            this.cacheMissingKey = cacheMissingKey;
            return this;
        }

        public DefaultLookupCache build() {
            return new DefaultLookupCache(this.expireAfterAccessDuration, this.expireAfterWriteDuration, this.maximumSize, this.cacheMissingKey);
        }
    }
}

