/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli.parser;

import java.io.StringReader;
import java.util.Iterator;
import java.util.Optional;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImplTokenManager;
import org.apache.flink.sql.parser.impl.SimpleCharStream;
import org.apache.flink.sql.parser.impl.Token;
import org.apache.flink.sql.parser.impl.TokenMgrError;
import org.apache.flink.table.api.SqlParserEOFException;
import org.apache.flink.table.client.cli.parser.Command;
import org.apache.flink.table.client.cli.parser.SqlCommandParser;
import org.apache.flink.table.client.gateway.SqlExecutionException;

public class SqlCommandParserImpl
implements SqlCommandParser {
    @Override
    public Optional<Command> parseStatement(String statement) throws SqlExecutionException {
        if ((statement = statement.trim()).isEmpty() || statement.equals(";")) {
            return Optional.empty();
        }
        return Optional.of(this.getCommand(new TokenIterator(statement)));
    }

    private Command getCommand(TokenIterator tokens) {
        if (!tokens.hasNext()) {
            SqlCommandParserImpl.continueReadInput();
        }
        Token firstToken = tokens.scan(0);
        Command type = firstToken.kind == 831 ? this.getPotentialCommandType(firstToken.image) : Command.OTHER;
        this.checkIncompleteStatement(tokens);
        return type;
    }

    private static void continueReadInput() {
        throw new SqlExecutionException("The SQL statement is incomplete.", new SqlParserEOFException("The SQL statement is incomplete."));
    }

    private boolean tokenMatches(Token token, int kind) {
        return token.kind == kind;
    }

    private Command getPotentialCommandType(String image) {
        switch (image.toUpperCase()) {
            case "QUIT": 
            case "EXIT": {
                return Command.QUIT;
            }
            case "CLEAR": {
                return Command.CLEAR;
            }
            case "HELP": {
                return Command.HELP;
            }
        }
        return Command.OTHER;
    }

    private void checkIncompleteStatement(TokenIterator iterator) {
        Token before = iterator.next();
        Token current = iterator.next();
        while (!this.tokenMatches(current, 0)) {
            before = current;
            current = iterator.next();
        }
        if (!this.tokenMatches(before, 788) || !this.tokenMatches(current, 0)) {
            SqlCommandParserImpl.continueReadInput();
        }
    }

    private static class TokenIterator
    implements Iterator<Token> {
        private final FlinkSqlParserImplTokenManager tokenManager;
        private Token currentToken;

        public TokenIterator(String statement) {
            this.tokenManager = new FlinkSqlParserImplTokenManager(new SimpleCharStream(new StringReader(statement)));
            this.tokenManager.SwitchTo(2);
            this.currentToken = this.tokenManager.getNextToken();
        }

        @Override
        public boolean hasNext() {
            return this.currentToken.kind != 0;
        }

        @Override
        public Token next() {
            Token before = this.currentToken;
            this.currentToken = this.scan(1);
            return before;
        }

        public Token scan(int pos) {
            Token current = this.currentToken;
            while (pos-- > 0) {
                if (current.next == null) {
                    try {
                        current.next = this.tokenManager.getNextToken();
                    }
                    catch (TokenMgrError tme) {
                        throw new SqlExecutionException("SQL parse failed. " + tme.getMessage(), tme);
                    }
                }
                current = current.next;
            }
            return current;
        }
    }
}

