/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.Constraint;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class Schema {
    private static final Schema EMPTY = Schema.newBuilder().build();
    private final List<UnresolvedColumn> columns;
    private final List<UnresolvedWatermarkSpec> watermarkSpecs;
    @Nullable
    private final UnresolvedPrimaryKey primaryKey;

    private Schema(List<UnresolvedColumn> columns, List<UnresolvedWatermarkSpec> watermarkSpecs, @Nullable UnresolvedPrimaryKey primaryKey) {
        this.columns = Collections.unmodifiableList(columns);
        this.watermarkSpecs = Collections.unmodifiableList(watermarkSpecs);
        this.primaryKey = primaryKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Schema derived() {
        return EMPTY;
    }

    public List<UnresolvedColumn> getColumns() {
        return this.columns;
    }

    public List<UnresolvedWatermarkSpec> getWatermarkSpecs() {
        return this.watermarkSpecs;
    }

    public Optional<UnresolvedPrimaryKey> getPrimaryKey() {
        return Optional.ofNullable(this.primaryKey);
    }

    public ResolvedSchema resolve(SchemaResolver resolver) {
        return resolver.resolve(this);
    }

    public String toString() {
        ArrayList<Object> components = new ArrayList<Object>();
        components.addAll(this.columns);
        components.addAll(this.watermarkSpecs);
        if (this.primaryKey != null) {
            components.add(this.primaryKey);
        }
        return components.stream().map(Objects::toString).map(s -> "  " + s).collect(Collectors.joining(",\n", "(\n", "\n)"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return this.columns.equals(schema.columns) && this.watermarkSpecs.equals(schema.watermarkSpecs) && Objects.equals(this.primaryKey, schema.primaryKey);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.watermarkSpecs, this.primaryKey);
    }

    @PublicEvolving
    public static final class UnresolvedPrimaryKey
    extends UnresolvedConstraint {
        private final List<String> columnNames;

        public UnresolvedPrimaryKey(String constraintName, List<String> columnNames) {
            super(constraintName);
            this.columnNames = columnNames;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        @Override
        public String toString() {
            return String.format("%s PRIMARY KEY (%s) NOT ENFORCED", super.toString(), this.columnNames.stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", ")));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnresolvedPrimaryKey that = (UnresolvedPrimaryKey)o;
            return this.columnNames.equals(that.columnNames);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.columnNames);
        }
    }

    @PublicEvolving
    public static abstract class UnresolvedConstraint {
        private final String constraintName;

        UnresolvedConstraint(String constraintName) {
            this.constraintName = constraintName;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public String toString() {
            return String.format("CONSTRAINT %s", EncodingUtils.escapeIdentifier(this.constraintName));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnresolvedConstraint that = (UnresolvedConstraint)o;
            return this.constraintName.equals(that.constraintName);
        }

        public int hashCode() {
            return Objects.hash(this.constraintName);
        }
    }

    @PublicEvolving
    public static final class UnresolvedWatermarkSpec {
        private final String columnName;
        private final Expression watermarkExpression;

        public UnresolvedWatermarkSpec(String columnName, Expression watermarkExpression) {
            this.columnName = columnName;
            this.watermarkExpression = watermarkExpression;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Expression getWatermarkExpression() {
            return this.watermarkExpression;
        }

        public String toString() {
            return String.format("WATERMARK FOR %s AS %s", EncodingUtils.escapeIdentifier(this.columnName), this.watermarkExpression.asSummaryString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnresolvedWatermarkSpec that = (UnresolvedWatermarkSpec)o;
            return this.columnName.equals(that.columnName) && this.watermarkExpression.equals(that.watermarkExpression);
        }

        public int hashCode() {
            return Objects.hash(this.columnName, this.watermarkExpression);
        }
    }

    @PublicEvolving
    public static final class UnresolvedMetadataColumn
    extends UnresolvedColumn {
        private final AbstractDataType<?> dataType;
        @Nullable
        private final String metadataKey;
        private final boolean isVirtual;

        public UnresolvedMetadataColumn(String columnName, AbstractDataType<?> dataType, @Nullable String metadataKey, boolean isVirtual) {
            this(columnName, dataType, metadataKey, isVirtual, null);
        }

        public UnresolvedMetadataColumn(String columnName, AbstractDataType<?> dataType, @Nullable String metadataKey, boolean isVirtual, @Nullable String comment) {
            super(columnName, comment);
            this.dataType = dataType;
            this.metadataKey = metadataKey;
            this.isVirtual = isVirtual;
        }

        @Override
        UnresolvedMetadataColumn withComment(@Nullable String comment) {
            return new UnresolvedMetadataColumn(this.columnName, this.dataType, this.metadataKey, this.isVirtual, comment);
        }

        public AbstractDataType<?> getDataType() {
            return this.dataType;
        }

        @Nullable
        public String getMetadataKey() {
            return this.metadataKey;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" METADATA");
            if (this.metadataKey != null) {
                sb.append(" FROM '");
                sb.append(EncodingUtils.escapeSingleQuotes(this.metadataKey));
                sb.append("'");
            }
            if (this.isVirtual) {
                sb.append(" VIRTUAL");
            }
            this.getComment().ifPresent(c -> {
                sb.append(" COMMENT '");
                sb.append(EncodingUtils.escapeSingleQuotes(c));
                sb.append("'");
            });
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnresolvedMetadataColumn that = (UnresolvedMetadataColumn)o;
            return this.isVirtual == that.isVirtual && this.dataType.equals(that.dataType) && Objects.equals(this.metadataKey, that.metadataKey);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dataType, this.metadataKey, this.isVirtual);
        }
    }

    @PublicEvolving
    public static final class UnresolvedComputedColumn
    extends UnresolvedColumn {
        private final Expression expression;

        public UnresolvedComputedColumn(String columnName, Expression expression) {
            this(columnName, expression, null);
        }

        public UnresolvedComputedColumn(String columnName, Expression expression, String comment) {
            super(columnName, comment);
            this.expression = expression;
        }

        @Override
        public UnresolvedComputedColumn withComment(String comment) {
            return new UnresolvedComputedColumn(this.columnName, this.expression, comment);
        }

        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s AS %s", super.toString(), this.expression.asSummaryString()));
            this.getComment().ifPresent(c -> {
                sb.append(" COMMENT '");
                sb.append(EncodingUtils.escapeSingleQuotes(c));
                sb.append("'");
            });
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnresolvedComputedColumn that = (UnresolvedComputedColumn)o;
            return this.expression.equals(that.expression);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.expression);
        }
    }

    @PublicEvolving
    public static final class UnresolvedPhysicalColumn
    extends UnresolvedColumn {
        private final AbstractDataType<?> dataType;

        public UnresolvedPhysicalColumn(String columnName, AbstractDataType<?> dataType) {
            this(columnName, dataType, null);
        }

        public UnresolvedPhysicalColumn(String columnName, AbstractDataType<?> dataType, @Nullable String comment) {
            super(columnName, comment);
            this.dataType = dataType;
        }

        @Override
        UnresolvedPhysicalColumn withComment(String comment) {
            return new UnresolvedPhysicalColumn(this.columnName, this.dataType, comment);
        }

        public AbstractDataType<?> getDataType() {
            return this.dataType;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s %s", super.toString(), this.dataType.toString()));
            this.getComment().ifPresent(c -> {
                sb.append(" COMMENT '");
                sb.append(EncodingUtils.escapeSingleQuotes(c));
                sb.append("'");
            });
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnresolvedPhysicalColumn that = (UnresolvedPhysicalColumn)o;
            return this.dataType.equals(that.dataType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dataType);
        }
    }

    @PublicEvolving
    public static abstract class UnresolvedColumn {
        final String columnName;
        @Nullable
        final String comment;

        UnresolvedColumn(String columnName, @Nullable String comment) {
            this.columnName = columnName;
            this.comment = comment;
        }

        public String getName() {
            return this.columnName;
        }

        public Optional<String> getComment() {
            return Optional.ofNullable(this.comment);
        }

        abstract UnresolvedColumn withComment(@Nullable String var1);

        public String toString() {
            return EncodingUtils.escapeIdentifier(this.columnName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnresolvedColumn that = (UnresolvedColumn)o;
            return this.columnName.equals(that.columnName) && Objects.equals(this.comment, that.comment);
        }

        public int hashCode() {
            return Objects.hash(this.columnName);
        }
    }

    @PublicEvolving
    public static final class Builder {
        private final List<UnresolvedColumn> columns = new ArrayList<UnresolvedColumn>();
        private final List<UnresolvedWatermarkSpec> watermarkSpecs = new ArrayList<UnresolvedWatermarkSpec>();
        @Nullable
        private UnresolvedPrimaryKey primaryKey;

        private Builder() {
        }

        public Builder fromSchema(Schema unresolvedSchema) {
            this.columns.addAll(unresolvedSchema.columns);
            this.watermarkSpecs.addAll(unresolvedSchema.watermarkSpecs);
            if (unresolvedSchema.primaryKey != null) {
                this.primaryKeyNamed(unresolvedSchema.primaryKey.getConstraintName(), unresolvedSchema.primaryKey.getColumnNames());
            }
            return this;
        }

        public Builder fromResolvedSchema(ResolvedSchema resolvedSchema) {
            this.addResolvedColumns(resolvedSchema.getColumns());
            this.addResolvedWatermarkSpec(resolvedSchema.getWatermarkSpecs());
            resolvedSchema.getPrimaryKey().ifPresent(this::addResolvedConstraint);
            return this;
        }

        public Builder fromRowDataType(DataType dataType) {
            Preconditions.checkNotNull(dataType, "Data type must not be null.");
            Preconditions.checkArgument(dataType.getLogicalType().is(LogicalTypeRoot.ROW), "Data type of ROW expected.");
            List<DataType> fieldDataTypes = dataType.getChildren();
            List<String> fieldNames = ((RowType)dataType.getLogicalType()).getFieldNames();
            IntStream.range(0, fieldDataTypes.size()).forEach(i -> this.column((String)fieldNames.get(i), (AbstractDataType)fieldDataTypes.get(i)));
            return this;
        }

        public Builder fromFields(String[] fieldNames, AbstractDataType<?>[] fieldDataTypes) {
            Preconditions.checkNotNull(fieldNames, "Field names must not be null.");
            Preconditions.checkNotNull(fieldDataTypes, "Field data types must not be null.");
            Preconditions.checkArgument(fieldNames.length == fieldDataTypes.length, "Field names and field data types must have the same length.");
            IntStream.range(0, fieldNames.length).forEach(i -> this.column(fieldNames[i], fieldDataTypes[i]));
            return this;
        }

        public Builder fromFields(List<String> fieldNames, List<? extends AbstractDataType<?>> fieldDataTypes) {
            Preconditions.checkNotNull(fieldNames, "Field names must not be null.");
            Preconditions.checkNotNull(fieldDataTypes, "Field data types must not be null.");
            Preconditions.checkArgument(fieldNames.size() == fieldDataTypes.size(), "Field names and field data types must have the same length.");
            IntStream.range(0, fieldNames.size()).forEach(i -> this.column((String)fieldNames.get(i), (AbstractDataType)fieldDataTypes.get(i)));
            return this;
        }

        public Builder fromColumns(List<UnresolvedColumn> unresolvedColumns) {
            this.columns.addAll(unresolvedColumns);
            return this;
        }

        public Builder column(String columnName, AbstractDataType<?> dataType) {
            Preconditions.checkNotNull(columnName, "Column name must not be null.");
            Preconditions.checkNotNull(dataType, "Data type must not be null.");
            this.columns.add(new UnresolvedPhysicalColumn(columnName, dataType));
            return this;
        }

        public Builder column(String columnName, String serializableTypeString) {
            return this.column(columnName, DataTypes.of(serializableTypeString));
        }

        public Builder columnByExpression(String columnName, Expression expression) {
            Preconditions.checkNotNull(columnName, "Column name must not be null.");
            Preconditions.checkNotNull(expression, "Expression must not be null.");
            this.columns.add(new UnresolvedComputedColumn(columnName, expression));
            return this;
        }

        public Builder columnByExpression(String columnName, String sqlExpression) {
            return this.columnByExpression(columnName, new SqlCallExpression(sqlExpression));
        }

        public Builder columnByMetadata(String columnName, AbstractDataType<?> dataType) {
            return this.columnByMetadata(columnName, dataType, null, false);
        }

        public Builder columnByMetadata(String columnName, String serializableTypeString) {
            return this.columnByMetadata(columnName, serializableTypeString, null, false);
        }

        public Builder columnByMetadata(String columnName, AbstractDataType<?> dataType, boolean isVirtual) {
            return this.columnByMetadata(columnName, dataType, null, isVirtual);
        }

        public Builder columnByMetadata(String columnName, AbstractDataType<?> dataType, @Nullable String metadataKey) {
            return this.columnByMetadata(columnName, dataType, metadataKey, false);
        }

        public Builder columnByMetadata(String columnName, AbstractDataType<?> dataType, @Nullable String metadataKey, boolean isVirtual) {
            Preconditions.checkNotNull(columnName, "Column name must not be null.");
            Preconditions.checkNotNull(dataType, "Data type must not be null.");
            this.columns.add(new UnresolvedMetadataColumn(columnName, dataType, metadataKey, isVirtual));
            return this;
        }

        public Builder columnByMetadata(String columnName, String serializableTypeString, @Nullable String metadataKey, boolean isVirtual) {
            return this.columnByMetadata(columnName, DataTypes.of(serializableTypeString), metadataKey, isVirtual);
        }

        public Builder withComment(@Nullable String comment) {
            if (this.columns.size() <= 0) {
                throw new IllegalArgumentException("Method 'withComment(...)' must be called after a column definition, but there is no preceding column defined.");
            }
            this.columns.set(this.columns.size() - 1, this.columns.get(this.columns.size() - 1).withComment(comment));
            return this;
        }

        public Builder watermark(String columnName, Expression watermarkExpression) {
            Preconditions.checkNotNull(columnName, "Column name must not be null.");
            Preconditions.checkNotNull(watermarkExpression, "Watermark expression must not be null.");
            this.watermarkSpecs.add(new UnresolvedWatermarkSpec(columnName, watermarkExpression));
            return this;
        }

        public Builder watermark(String columnName, String sqlExpression) {
            return this.watermark(columnName, new SqlCallExpression(sqlExpression));
        }

        public Builder primaryKey(String ... columnNames) {
            Preconditions.checkNotNull(columnNames, "Primary key column names must not be null.");
            return this.primaryKey(Arrays.asList(columnNames));
        }

        public Builder primaryKey(List<String> columnNames) {
            Preconditions.checkNotNull(columnNames, "Primary key column names must not be null.");
            String generatedConstraintName = columnNames.stream().collect(Collectors.joining("_", "PK_", ""));
            return this.primaryKeyNamed(generatedConstraintName, columnNames);
        }

        public Builder primaryKeyNamed(String constraintName, String ... columnNames) {
            Preconditions.checkNotNull(columnNames, "Primary key column names must not be null.");
            return this.primaryKeyNamed(constraintName, Arrays.asList(columnNames));
        }

        public Builder primaryKeyNamed(String constraintName, List<String> columnNames) {
            Preconditions.checkState(this.primaryKey == null, "Multiple primary keys are not supported.");
            Preconditions.checkNotNull(constraintName, "Primary key constraint name must not be null.");
            Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(constraintName), "Primary key constraint name must not be empty.");
            Preconditions.checkArgument(columnNames != null && columnNames.size() > 0, "Primary key constraint must be defined for at least a single column.");
            this.primaryKey = new UnresolvedPrimaryKey(constraintName, columnNames);
            return this;
        }

        public Schema build() {
            return new Schema(this.columns, this.watermarkSpecs, this.primaryKey);
        }

        private void addResolvedColumns(List<Column> columns) {
            columns.forEach(c -> {
                if (c instanceof Column.PhysicalColumn) {
                    Column.PhysicalColumn physicalColumn = (Column.PhysicalColumn)c;
                    this.column(physicalColumn.getName(), physicalColumn.getDataType());
                } else if (c instanceof Column.ComputedColumn) {
                    Column.ComputedColumn computedColumn = (Column.ComputedColumn)c;
                    this.columnByExpression(computedColumn.getName(), computedColumn.getExpression());
                } else if (c instanceof Column.MetadataColumn) {
                    Column.MetadataColumn metadataColumn = (Column.MetadataColumn)c;
                    this.columnByMetadata(metadataColumn.getName(), metadataColumn.getDataType(), (String)metadataColumn.getMetadataKey().orElse(null), metadataColumn.isVirtual());
                }
            });
        }

        private void addResolvedWatermarkSpec(List<WatermarkSpec> specs) {
            specs.forEach(s -> this.watermarkSpecs.add(new UnresolvedWatermarkSpec(s.getRowtimeAttribute(), s.getWatermarkExpression())));
        }

        private void addResolvedConstraint(UniqueConstraint constraint) {
            if (constraint.getType() != Constraint.ConstraintType.PRIMARY_KEY) {
                throw new IllegalArgumentException("Unsupported constraint type.");
            }
            this.primaryKeyNamed(constraint.getName(), constraint.getColumns());
        }
    }
}

