/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sortpartition;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public class FixedLengthByteKeyAndValueComparator<INPUT>
extends TypeComparator<Tuple2<byte[], INPUT>> {
    private final int serializedKeyLength;
    private final TypeComparator<INPUT> valueComparator;
    private byte[] keyReference;
    private INPUT valueReference;

    FixedLengthByteKeyAndValueComparator(int serializedKeyLength, TypeComparator<INPUT> valueComparator) {
        this.serializedKeyLength = serializedKeyLength;
        this.valueComparator = valueComparator;
    }

    @Override
    public int hash(Tuple2<byte[], INPUT> record) {
        return record.hashCode();
    }

    @Override
    public void setReference(Tuple2<byte[], INPUT> toCompare) {
        this.keyReference = (byte[])toCompare.f0;
        this.valueReference = toCompare.f1;
    }

    @Override
    public boolean equalToReference(Tuple2<byte[], INPUT> candidate) {
        return Arrays.equals(this.keyReference, (byte[])candidate.f0) && this.valueReference.equals(candidate.f1);
    }

    @Override
    public int compareToReference(TypeComparator<Tuple2<byte[], INPUT>> referencedComparator) {
        byte[] otherKey = ((FixedLengthByteKeyAndValueComparator)referencedComparator).keyReference;
        INPUT otherValue = ((FixedLengthByteKeyAndValueComparator)referencedComparator).valueReference;
        int keyCmp = this.compareKey(otherKey, this.keyReference);
        if (keyCmp != 0) {
            return keyCmp;
        }
        return this.valueComparator.compare(this.valueReference, otherValue);
    }

    @Override
    public int compare(Tuple2<byte[], INPUT> first, Tuple2<byte[], INPUT> second) {
        int keyCmp = this.compareKey((byte[])first.f0, (byte[])second.f0);
        if (keyCmp != 0) {
            return keyCmp;
        }
        return this.valueComparator.compare(first.f1, second.f1);
    }

    private int compareKey(byte[] first, byte[] second) {
        for (int i = 0; i < this.serializedKeyLength; ++i) {
            int cmp = Byte.compare(first[i], second[i]);
            if (cmp == 0) continue;
            return cmp < 0 ? -1 : 1;
        }
        return 0;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int minCount = this.serializedKeyLength;
        while (minCount-- > 0) {
            byte secondValue;
            byte firstValue = firstSource.readByte();
            int cmp = Byte.compare(firstValue, secondValue = secondSource.readByte());
            if (cmp == 0) continue;
            return cmp < 0 ? -1 : 1;
        }
        return this.valueComparator.compareSerialized(firstSource, secondSource);
    }

    @Override
    public boolean supportsNormalizedKey() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        throw new UnsupportedOperationException("Not supported as the data containing both key and value cannot generate normalized key.");
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return false;
    }

    @Override
    public void putNormalizedKey(Tuple2<byte[], INPUT> record, MemorySegment target, int offset, int numBytes) {
        throw new UnsupportedOperationException("Not supported as the data containing both key and value cannot generate normalized key.");
    }

    @Override
    public boolean invertNormalizedKey() {
        return false;
    }

    @Override
    public TypeComparator<Tuple2<byte[], INPUT>> duplicate() {
        return new FixedLengthByteKeyAndValueComparator<INPUT>(this.serializedKeyLength, this.valueComparator);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        return new TypeComparator[]{this};
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(Tuple2<byte[], INPUT> record, DataOutputView target) {
        throw new UnsupportedOperationException("Not supported as the data containing both key and value cannot generate normalized key.");
    }

    @Override
    public Tuple2<byte[], INPUT> readWithKeyDenormalization(Tuple2<byte[], INPUT> reuse, DataInputView source) {
        throw new UnsupportedOperationException("Not supported as the data containing both key and value cannot generate normalized key.");
    }
}

