/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExternalizedCheckpointRetention;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class CheckpointConfig
implements Serializable {
    private static final long serialVersionUID = -750378776078908147L;
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointConfig.class);
    private final Configuration configuration;

    public CheckpointConfig(CheckpointConfig checkpointConfig) {
        Preconditions.checkNotNull(checkpointConfig);
        this.configuration = new Configuration(checkpointConfig.configuration);
    }

    public CheckpointConfig() {
        this.configuration = new Configuration();
    }

    @Internal
    public CheckpointConfig(Configuration configuration) {
        this.configuration = configuration;
    }

    public void disableCheckpointing() {
        this.configuration.removeConfig(CheckpointingOptions.CHECKPOINTING_INTERVAL);
    }

    public boolean isCheckpointingEnabled() {
        return this.getCheckpointInterval() > 0L;
    }

    @Deprecated
    public CheckpointingMode getCheckpointingMode() {
        return CheckpointingMode.convertFromCheckpointingMode(this.configuration.get(CheckpointingOptions.CHECKPOINTING_CONSISTENCY_MODE));
    }

    @Deprecated
    public void setCheckpointingMode(CheckpointingMode checkpointingMode) {
        this.configuration.set((ConfigOption)CheckpointingOptions.CHECKPOINTING_CONSISTENCY_MODE, (Object)CheckpointingMode.convertToCheckpointingMode(checkpointingMode));
    }

    public org.apache.flink.core.execution.CheckpointingMode getCheckpointingConsistencyMode() {
        return this.configuration.get(CheckpointingOptions.CHECKPOINTING_CONSISTENCY_MODE);
    }

    public void setCheckpointingConsistencyMode(org.apache.flink.core.execution.CheckpointingMode checkpointingMode) {
        this.configuration.set((ConfigOption)CheckpointingOptions.CHECKPOINTING_CONSISTENCY_MODE, (Object)checkpointingMode);
    }

    public long getCheckpointInterval() {
        return this.configuration.getOptional(CheckpointingOptions.CHECKPOINTING_INTERVAL).map(Duration::toMillis).orElse(-1L);
    }

    public void setCheckpointInterval(long checkpointInterval) {
        if (checkpointInterval < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint interval must be larger than or equal to %s ms", 10L));
        }
        this.configuration.set((ConfigOption)CheckpointingOptions.CHECKPOINTING_INTERVAL, Duration.ofMillis(checkpointInterval));
    }

    public long getCheckpointIntervalDuringBacklog() {
        long checkpointInterval;
        long intervalDuringBacklog = this.configuration.getOptional(CheckpointingOptions.CHECKPOINTING_INTERVAL_DURING_BACKLOG).map(Duration::toMillis).orElseGet(this::getCheckpointInterval);
        if (intervalDuringBacklog < 10L) {
            intervalDuringBacklog = Long.MAX_VALUE;
        }
        if ((checkpointInterval = this.getCheckpointInterval()) < 10L) {
            checkpointInterval = Long.MAX_VALUE;
        }
        if (intervalDuringBacklog < checkpointInterval) {
            throw new IllegalArgumentException("Checkpoint interval during backlog must be larger than or equal to that in normal situation.");
        }
        return intervalDuringBacklog;
    }

    public void setCheckpointIntervalDuringBacklog(long checkpointInterval) {
        if (checkpointInterval != 0L && checkpointInterval < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint interval must be zero or larger than or equal to %s ms", 10L));
        }
        this.configuration.set((ConfigOption)CheckpointingOptions.CHECKPOINTING_INTERVAL_DURING_BACKLOG, Duration.ofMillis(checkpointInterval));
    }

    public long getCheckpointTimeout() {
        return this.configuration.get(CheckpointingOptions.CHECKPOINTING_TIMEOUT).toMillis();
    }

    public void setCheckpointTimeout(long checkpointTimeout) {
        if (checkpointTimeout < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint timeout must be larger than or equal to %s ms", 10L));
        }
        this.configuration.set((ConfigOption)CheckpointingOptions.CHECKPOINTING_TIMEOUT, Duration.ofMillis(checkpointTimeout));
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.configuration.get(CheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS).toMillis();
    }

    public void setMinPauseBetweenCheckpoints(long minPauseBetweenCheckpoints) {
        if (minPauseBetweenCheckpoints < 0L) {
            throw new IllegalArgumentException("Pause value must be zero or positive");
        }
        this.configuration.set((ConfigOption)CheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS, Duration.ofMillis(minPauseBetweenCheckpoints));
    }

    public int getMaxConcurrentCheckpoints() {
        return this.configuration.get(CheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS);
    }

    public void setMaxConcurrentCheckpoints(int maxConcurrentCheckpoints) {
        if (maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException("The maximum number of concurrent attempts must be at least one.");
        }
        this.configuration.set((ConfigOption)CheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS, (Object)maxConcurrentCheckpoints);
    }

    @PublicEvolving
    public boolean isForceUnalignedCheckpoints() {
        return this.configuration.get(CheckpointingOptions.FORCE_UNALIGNED);
    }

    @PublicEvolving
    public void setForceUnalignedCheckpoints(boolean forceUnalignedCheckpoints) {
        this.configuration.set((ConfigOption)CheckpointingOptions.FORCE_UNALIGNED, (Object)forceUnalignedCheckpoints);
    }

    public int getTolerableCheckpointFailureNumber() {
        return this.configuration.get(CheckpointingOptions.TOLERABLE_FAILURE_NUMBER);
    }

    public void setTolerableCheckpointFailureNumber(int tolerableCheckpointFailureNumber) {
        if (tolerableCheckpointFailureNumber < 0) {
            throw new IllegalArgumentException("The tolerable failure checkpoint number must be non-negative.");
        }
        this.configuration.set((ConfigOption)CheckpointingOptions.TOLERABLE_FAILURE_NUMBER, (Object)tolerableCheckpointFailureNumber);
    }

    @PublicEvolving
    public void setExternalizedCheckpointRetention(ExternalizedCheckpointRetention cleanupMode) {
        this.configuration.set((ConfigOption)CheckpointingOptions.EXTERNALIZED_CHECKPOINT_RETENTION, cleanupMode);
    }

    @PublicEvolving
    public boolean isExternalizedCheckpointsEnabled() {
        return this.getExternalizedCheckpointRetention() != ExternalizedCheckpointRetention.NO_EXTERNALIZED_CHECKPOINTS;
    }

    @PublicEvolving
    public void enableUnalignedCheckpoints(boolean enabled) {
        this.configuration.set((ConfigOption)CheckpointingOptions.ENABLE_UNALIGNED, (Object)enabled);
    }

    @PublicEvolving
    public void enableUnalignedCheckpoints() {
        this.enableUnalignedCheckpoints(true);
    }

    @PublicEvolving
    public boolean isUnalignedCheckpointsEnabled() {
        return this.configuration.get(CheckpointingOptions.ENABLE_UNALIGNED);
    }

    @Experimental
    public void enableUnalignedCheckpointsInterruptibleTimers(boolean enabled) {
        this.configuration.set((ConfigOption)CheckpointingOptions.ENABLE_UNALIGNED_INTERRUPTIBLE_TIMERS, (Object)enabled);
    }

    @Experimental
    public boolean isUnalignedCheckpointsInterruptibleTimersEnabled() {
        return this.configuration.get(CheckpointingOptions.ENABLE_UNALIGNED_INTERRUPTIBLE_TIMERS);
    }

    @PublicEvolving
    public Duration getAlignedCheckpointTimeout() {
        return this.configuration.get(CheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT);
    }

    @PublicEvolving
    public void setAlignedCheckpointTimeout(Duration alignedCheckpointTimeout) {
        this.configuration.set((ConfigOption)CheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT, alignedCheckpointTimeout);
    }

    @PublicEvolving
    public int getMaxSubtasksPerChannelStateFile() {
        return this.configuration.get(CheckpointingOptions.UNALIGNED_MAX_SUBTASKS_PER_CHANNEL_STATE_FILE);
    }

    @PublicEvolving
    public void setMaxSubtasksPerChannelStateFile(int maxSubtasksPerChannelStateFile) {
        this.configuration.set((ConfigOption)CheckpointingOptions.UNALIGNED_MAX_SUBTASKS_PER_CHANNEL_STATE_FILE, (Object)maxSubtasksPerChannelStateFile);
    }

    @Experimental
    public boolean isApproximateLocalRecoveryEnabled() {
        return this.configuration.get(StateRecoveryOptions.APPROXIMATE_LOCAL_RECOVERY);
    }

    @Experimental
    public void enableApproximateLocalRecovery(boolean enabled) {
        this.configuration.set((ConfigOption)StateRecoveryOptions.APPROXIMATE_LOCAL_RECOVERY, (Object)enabled);
    }

    @PublicEvolving
    public ExternalizedCheckpointRetention getExternalizedCheckpointRetention() {
        return this.configuration.get(CheckpointingOptions.EXTERNALIZED_CHECKPOINT_RETENTION);
    }

    @PublicEvolving
    public void setCheckpointIdOfIgnoredInFlightData(long checkpointIdOfIgnoredInFlightData) {
        this.configuration.set((ConfigOption)StateRecoveryOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA, (Object)checkpointIdOfIgnoredInFlightData);
    }

    @PublicEvolving
    public long getCheckpointIdOfIgnoredInFlightData() {
        return this.configuration.get(StateRecoveryOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA);
    }

    public void configure(ReadableConfig configuration) {
        configuration.getOptional(CheckpointingOptions.CHECKPOINTING_CONSISTENCY_MODE).ifPresent(this::setCheckpointingConsistencyMode);
        configuration.getOptional(CheckpointingOptions.CHECKPOINTING_INTERVAL).ifPresent(i -> this.setCheckpointInterval(i.toMillis()));
        configuration.getOptional(CheckpointingOptions.CHECKPOINTING_INTERVAL_DURING_BACKLOG).ifPresent(i -> this.setCheckpointIntervalDuringBacklog(i.toMillis()));
        configuration.getOptional(CheckpointingOptions.CHECKPOINTING_TIMEOUT).ifPresent(t -> this.setCheckpointTimeout(t.toMillis()));
        configuration.getOptional(CheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS).ifPresent(this::setMaxConcurrentCheckpoints);
        configuration.getOptional(CheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS).ifPresent(m -> this.setMinPauseBetweenCheckpoints(m.toMillis()));
        configuration.getOptional(CheckpointingOptions.TOLERABLE_FAILURE_NUMBER).ifPresent(this::setTolerableCheckpointFailureNumber);
        configuration.getOptional(CheckpointingOptions.EXTERNALIZED_CHECKPOINT_RETENTION).ifPresent(this::setExternalizedCheckpointRetention);
        configuration.getOptional(CheckpointingOptions.ENABLE_UNALIGNED).ifPresent(this::enableUnalignedCheckpoints);
        configuration.getOptional(CheckpointingOptions.ENABLE_UNALIGNED_INTERRUPTIBLE_TIMERS).ifPresent(this::enableUnalignedCheckpointsInterruptibleTimers);
        configuration.getOptional(StateRecoveryOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA).ifPresent(this::setCheckpointIdOfIgnoredInFlightData);
        configuration.getOptional(CheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT).ifPresent(this::setAlignedCheckpointTimeout);
        configuration.getOptional(CheckpointingOptions.UNALIGNED_MAX_SUBTASKS_PER_CHANNEL_STATE_FILE).ifPresent(this::setMaxSubtasksPerChannelStateFile);
        configuration.getOptional(CheckpointingOptions.FORCE_UNALIGNED).ifPresent(this::setForceUnalignedCheckpoints);
        configuration.getOptional(CheckpointingOptions.CHECKPOINTS_DIRECTORY).ifPresent(this::setCheckpointDirectory);
    }

    private void setCheckpointDirectory(String checkpointDirectory) {
        Preconditions.checkNotNull(checkpointDirectory, "Checkpoint directory must not be null");
        this.configuration.set((ConfigOption)CheckpointingOptions.CHECKPOINTS_DIRECTORY, checkpointDirectory);
    }

    @Internal
    public Configuration toConfiguration() {
        return new Configuration(this.configuration);
    }
}

