/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.partition;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public class ClusterPartitionReport
implements Serializable {
    private static final long serialVersionUID = -3150175198722481689L;
    private final Collection<ClusterPartitionReportEntry> entries;

    public ClusterPartitionReport(Collection<ClusterPartitionReportEntry> entries) {
        this.entries = Preconditions.checkNotNull(entries);
    }

    public Collection<ClusterPartitionReportEntry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return "PartitionReport{entries=" + this.entries + "}";
    }

    public static class ClusterPartitionReportEntry
    implements Serializable {
        private static final long serialVersionUID = -666517548300250601L;
        private final IntermediateDataSetID dataSetId;
        private final Map<ResultPartitionID, ShuffleDescriptor> shuffleDescriptors;
        private final int numTotalPartitions;

        public ClusterPartitionReportEntry(IntermediateDataSetID dataSetId, int numTotalPartitions, Map<ResultPartitionID, ShuffleDescriptor> shuffleDescriptors) {
            Preconditions.checkNotNull(dataSetId);
            Preconditions.checkNotNull(shuffleDescriptors);
            Preconditions.checkArgument(!shuffleDescriptors.isEmpty());
            Preconditions.checkArgument(numTotalPartitions > 0);
            Preconditions.checkState(shuffleDescriptors.size() <= numTotalPartitions);
            this.dataSetId = dataSetId;
            this.numTotalPartitions = numTotalPartitions;
            this.shuffleDescriptors = shuffleDescriptors;
        }

        public IntermediateDataSetID getDataSetId() {
            return this.dataSetId;
        }

        public Set<ResultPartitionID> getHostedPartitions() {
            return this.shuffleDescriptors.keySet();
        }

        public int getNumTotalPartitions() {
            return this.numTotalPartitions;
        }

        public Map<ResultPartitionID, ShuffleDescriptor> getShuffleDescriptors() {
            return this.shuffleDescriptors;
        }
    }
}

