/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public abstract class AbstractExecutionGraphHandler<R extends ResponseBody, M extends JobMessageParameters>
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, R, M> {
    private final ExecutionGraphCache executionGraphCache;
    private final Executor executor;

    protected AbstractExecutionGraphHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.executionGraphCache = Preconditions.checkNotNull(executionGraphCache);
        this.executor = Preconditions.checkNotNull(executor);
    }

    @Override
    protected CompletableFuture<R> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        CompletableFuture<ExecutionGraphInfo> executionGraphFuture = this.executionGraphCache.getExecutionGraphInfo(jobId, gateway);
        return ((CompletableFuture)executionGraphFuture.thenApplyAsync(executionGraph -> {
            try {
                return this.handleRequest(request, (ExecutionGraphInfo)executionGraph);
            }
            catch (RestHandlerException rhe) {
                throw new CompletionException(rhe);
            }
        }, this.executor)).exceptionally(throwable -> {
            if ((throwable = ExceptionUtils.stripCompletionException(throwable)) instanceof FlinkJobNotFoundException) {
                throw new CompletionException(new NotFoundException(String.format("Job %s not found", jobId), (Throwable)throwable));
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    protected abstract R handleRequest(HandlerRequest<EmptyRequestBody> var1, ExecutionGraphInfo var2) throws RestHandlerException;
}

