/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFilePool;
import org.apache.flink.runtime.state.CheckpointedStateScope;

public class BlockingPhysicalFilePool
extends PhysicalFilePool {
    private final AtomicBoolean exclusivePhysicalFilePoolInitialized = new AtomicBoolean(false);

    public BlockingPhysicalFilePool(long maxFileSize, PhysicalFile.PhysicalFileCreator physicalFileCreator) {
        super(maxFileSize, physicalFileCreator);
    }

    @Override
    public boolean tryPutFile(FileMergingSnapshotManager.SubtaskKey subtaskKey, PhysicalFile physicalFile) throws IOException {
        if (physicalFile.getSize() < this.maxFileSize) {
            return this.getFileQueue(subtaskKey, physicalFile.getScope()).offer(physicalFile);
        }
        this.getFileQueue(subtaskKey, physicalFile.getScope()).offer(this.physicalFileCreator.perform(subtaskKey, physicalFile.getScope()));
        return false;
    }

    @Override
    @Nonnull
    public PhysicalFile pollFile(FileMergingSnapshotManager.SubtaskKey subtaskKey, CheckpointedStateScope scope) throws IOException {
        this.initialize(subtaskKey, scope);
        try {
            return (PhysicalFile)((BlockingQueue)this.getFileQueue(subtaskKey, scope)).take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void initialize(FileMergingSnapshotManager.SubtaskKey subtaskKey, CheckpointedStateScope scope) throws IOException {
        if (scope.equals((Object)CheckpointedStateScope.SHARED)) {
            AtomicBoolean init = new AtomicBoolean(false);
            Queue fileQueue = this.sharedPhysicalFilePoolBySubtask.computeIfAbsent(subtaskKey, key -> {
                init.set(true);
                return this.createFileQueue();
            });
            if (init.get()) {
                fileQueue.offer(this.physicalFileCreator.perform(subtaskKey, scope));
            }
        } else if (scope.equals((Object)CheckpointedStateScope.EXCLUSIVE) && this.exclusivePhysicalFilePoolInitialized.compareAndSet(false, true)) {
            this.getFileQueue(subtaskKey, scope).offer(this.physicalFileCreator.perform(subtaskKey, scope));
        }
    }

    @Override
    protected Queue<PhysicalFile> createFileQueue() {
        return new LinkedBlockingQueue<PhysicalFile>();
    }
}

