/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Serializer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.flink.api.common.SerializableSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.LinkedOptionalMap;
import org.apache.flink.util.LinkedOptionalMapSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiFunctionWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KryoSerializerSnapshotData<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializerSnapshotData.class);
    private final Class<T> typeClass;
    private final LinkedOptionalMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers;
    private final LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses;
    private final LinkedOptionalMap<String, KryoRegistration> kryoRegistrations;

    static <T> KryoSerializerSnapshotData<T> createFrom(Class<T> typeClass, LinkedHashMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers, LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses, LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
        return new KryoSerializerSnapshotData<T>(typeClass, LinkedOptionalMap.optionalMapOf(defaultKryoSerializers, Class::getName), LinkedOptionalMap.optionalMapOf(defaultKryoSerializerClasses, Class::getName), LinkedOptionalMap.optionalMapOf(kryoRegistrations, Function.identity()));
    }

    static <T> KryoSerializerSnapshotData<T> createFrom(DataInputView in, ClassLoader cl) throws IOException {
        Class<T> typeClass = KryoSerializerSnapshotData.readTypeClass(in, cl);
        LinkedOptionalMap<String, KryoRegistration> kryoRegistrations = KryoSerializerSnapshotData.readKryoRegistrations(in, cl);
        LinkedOptionalMap<Class<?>, SerializableSerializer<?>> defaultSerializer = KryoSerializerSnapshotData.readDefaultKryoSerializers(in, cl);
        LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultSerializerClasses = KryoSerializerSnapshotData.readDefaultKryoSerializerClasses(in, cl);
        return new KryoSerializerSnapshotData<T>(typeClass, defaultSerializer, defaultSerializerClasses, kryoRegistrations);
    }

    private KryoSerializerSnapshotData(Class<T> typeClass, LinkedOptionalMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers, LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses, LinkedOptionalMap<String, KryoRegistration> kryoRegistrations) {
        this.typeClass = typeClass;
        this.defaultKryoSerializers = defaultKryoSerializers;
        this.defaultKryoSerializerClasses = defaultKryoSerializerClasses;
        this.kryoRegistrations = kryoRegistrations;
    }

    Class<T> getTypeClass() {
        return this.typeClass;
    }

    LinkedOptionalMap<Class<?>, SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultKryoSerializers;
    }

    LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultKryoSerializerClasses;
    }

    LinkedOptionalMap<String, KryoRegistration> getKryoRegistrations() {
        return this.kryoRegistrations;
    }

    void writeSnapshotData(DataOutputView out) throws IOException {
        this.writeTypeClass(out);
        KryoSerializerSnapshotData.writeKryoRegistrations(out, this.kryoRegistrations);
        this.writeDefaultKryoSerializers(out, this.defaultKryoSerializers);
        KryoSerializerSnapshotData.writeDefaultKryoSerializerClasses(out, this.defaultKryoSerializerClasses);
    }

    private void writeTypeClass(DataOutputView out) throws IOException {
        out.writeUTF(this.typeClass.getName());
    }

    private static void writeKryoRegistrations(DataOutputView out, LinkedOptionalMap<String, KryoRegistration> kryoRegistrations) throws IOException {
        LinkedOptionalMapSerializer.writeOptionalMap(out, kryoRegistrations, DataOutput::writeUTF, KryoRegistrationUtil::writeKryoRegistration);
    }

    private void writeDefaultKryoSerializers(DataOutputView out, LinkedOptionalMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers) throws IOException {
        LinkedOptionalMapSerializer.writeOptionalMap(out, defaultKryoSerializers, (stream, klass) -> stream.writeUTF(klass.getName()), (stream, instance) -> {
            try (DataOutputViewStream outViewWrapper = new DataOutputViewStream((DataOutputView)stream);){
                InstantiationUtil.serializeObject(outViewWrapper, instance);
            }
        });
    }

    private static void writeDefaultKryoSerializerClasses(DataOutputView out, LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses) throws IOException {
        LinkedOptionalMapSerializer.writeOptionalMap(out, defaultKryoSerializerClasses, (stream, klass) -> stream.writeUTF(klass.getName()), (stream, klass) -> stream.writeUTF(klass.getName()));
    }

    private static <T> Class<T> readTypeClass(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
    }

    private static LinkedOptionalMap<String, KryoRegistration> readKryoRegistrations(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return LinkedOptionalMapSerializer.readOptionalMap(in, (stream, unused) -> stream.readUTF(), (stream, unused) -> KryoRegistrationUtil.tryReadKryoRegistration(stream, userCodeClassLoader));
    }

    private static LinkedOptionalMap<Class<?>, SerializableSerializer<?>> readDefaultKryoSerializers(DataInputView in, ClassLoader cl) throws IOException {
        return LinkedOptionalMapSerializer.readOptionalMap(in, new ClassResolverByName(cl), new SerializeableSerializerResolver(cl));
    }

    private static LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> readDefaultKryoSerializerClasses(DataInputView in, ClassLoader cl) throws IOException {
        return LinkedOptionalMapSerializer.readOptionalMap(in, new ClassResolverByName(cl), new ClassResolverByName(cl));
    }

    private static final class SerializeableSerializerResolver
    implements BiFunctionWithException<DataInputView, String, SerializableSerializer<?>, IOException> {
        private final ClassLoader classLoader;

        private SerializeableSerializerResolver(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public SerializableSerializer<?> apply(DataInputView stream, String className) {
            SerializableSerializer serializableSerializer;
            DataInputViewStream inViewWrapper = new DataInputViewStream(stream);
            try {
                serializableSerializer = (SerializableSerializer)InstantiationUtil.deserializeObject(inViewWrapper, this.classLoader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inViewWrapper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    LOG.warn("Cannot deserialize a previously serialized kryo serializer for the type " + className, e);
                    return null;
                }
            }
            inViewWrapper.close();
            return serializableSerializer;
        }
    }

    private static class ClassResolverByName<T>
    implements BiFunctionWithException<DataInputView, String, Class<T>, IOException> {
        private final ClassLoader classLoader;

        private ClassResolverByName(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Class<T> apply(DataInputView stream, String unused) throws IOException {
            String className = stream.readUTF();
            try {
                return Class.forName(className, false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered class " + className + " for Kryo serialization in classpath.", (Throwable)e);
                return null;
            }
        }
    }

    private static final class KryoRegistrationUtil {
        private KryoRegistrationUtil() {
        }

        static void writeKryoRegistration(DataOutputView out, KryoRegistration kryoRegistration) throws IOException {
            Preconditions.checkNotNull(kryoRegistration);
            out.writeUTF(kryoRegistration.getRegisteredClass().getName());
            KryoRegistration.SerializerDefinitionType serializerDefinitionType = kryoRegistration.getSerializerDefinitionType();
            out.writeInt(serializerDefinitionType.ordinal());
            switch (serializerDefinitionType) {
                case UNSPECIFIED: {
                    break;
                }
                case CLASS: {
                    Class<Serializer<?>> serializerClass = kryoRegistration.getSerializerClass();
                    assert (serializerClass != null);
                    out.writeUTF(serializerClass.getName());
                    break;
                }
                case INSTANCE: {
                    try (DataOutputViewStream outViewWrapper = new DataOutputViewStream(out);){
                        InstantiationUtil.serializeObject(outViewWrapper, kryoRegistration.getSerializableSerializerInstance());
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException("Unrecognized Kryo registration serializer definition type: " + serializerDefinitionType);
                }
            }
        }

        static KryoRegistration tryReadKryoRegistration(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            Class<?> registeredClass;
            String registeredClassname = in.readUTF();
            try {
                registeredClass = Class.forName(registeredClassname, true, userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered class " + registeredClassname + " for Kryo serialization in classpath; using a dummy class as a placeholder.", (Throwable)e);
                return null;
            }
            KryoRegistration.SerializerDefinitionType serializerDefinitionType = KryoRegistration.SerializerDefinitionType.values()[in.readInt()];
            switch (serializerDefinitionType) {
                case UNSPECIFIED: {
                    return new KryoRegistration(registeredClass);
                }
                case CLASS: {
                    return KryoRegistrationUtil.tryReadWithSerializerClass(in, userCodeClassLoader, registeredClassname, registeredClass);
                }
                case INSTANCE: {
                    return KryoRegistrationUtil.tryReadWithSerializerInstance(in, userCodeClassLoader, registeredClassname, registeredClass);
                }
            }
            throw new IllegalStateException("Unrecognized Kryo registration serializer definition type: " + serializerDefinitionType);
        }

        private static KryoRegistration tryReadWithSerializerClass(DataInputView in, ClassLoader userCodeClassLoader, String registeredClassname, Class<?> registeredClass) throws IOException {
            String serializerClassname = in.readUTF();
            try {
                Class<?> serializerClass = Class.forName(serializerClassname, true, userCodeClassLoader);
                return new KryoRegistration(registeredClass, serializerClass);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered Kryo serializer class for class " + registeredClassname + " in classpath; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present", (Throwable)e);
                return null;
            }
        }

        private static KryoRegistration tryReadWithSerializerInstance(DataInputView in, ClassLoader userCodeClassLoader, String registeredClassname, Class<?> registeredClass) throws IOException {
            block8: {
                KryoRegistration kryoRegistration;
                DataInputViewStream inViewWrapper = new DataInputViewStream(in);
                try {
                    SerializableSerializer serializerInstance = (SerializableSerializer)InstantiationUtil.deserializeObject(inViewWrapper, userCodeClassLoader);
                    kryoRegistration = new KryoRegistration(registeredClass, serializerInstance);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            inViewWrapper.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn("Cannot find registered Kryo serializer class for class " + registeredClassname + " in classpath; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present", (Throwable)e);
                        break block8;
                    }
                    catch (InvalidClassException e) {
                        LOG.warn("The registered Kryo serializer class for class " + registeredClassname + " has changed and is no longer valid; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present.", (Throwable)e);
                    }
                }
                inViewWrapper.close();
                return kryoRegistration;
            }
            return null;
        }
    }
}

