/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public class SingleThreadAccessCheckingTypeSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 131020282727167064L;
    private final SingleThreadAccessChecker singleThreadAccessChecker = new SingleThreadAccessChecker();
    private final TypeSerializer<T> originalSerializer;

    public SingleThreadAccessCheckingTypeSerializer(TypeSerializer<T> originalSerializer) {
        this.originalSerializer = originalSerializer;
    }

    @Override
    public boolean isImmutableType() {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            boolean bl = this.originalSerializer.isImmutableType();
            return bl;
        }
    }

    @Override
    public TypeSerializer<T> duplicate() {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            SingleThreadAccessCheckingTypeSerializer<T> singleThreadAccessCheckingTypeSerializer = new SingleThreadAccessCheckingTypeSerializer<T>(this.originalSerializer.duplicate());
            return singleThreadAccessCheckingTypeSerializer;
        }
    }

    @Override
    public T createInstance() {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            T t = this.originalSerializer.createInstance();
            return t;
        }
    }

    @Override
    public T copy(T from) {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            T t = this.originalSerializer.copy(from);
            return t;
        }
    }

    @Override
    public T copy(T from, T reuse) {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            T t = this.originalSerializer.copy(from, reuse);
            return t;
        }
    }

    @Override
    public int getLength() {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            int n = this.originalSerializer.getLength();
            return n;
        }
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            this.originalSerializer.serialize(record, target);
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            T t = this.originalSerializer.deserialize(source);
            return t;
        }
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            T t = this.originalSerializer.deserialize(reuse, source);
            return t;
        }
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            this.originalSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            boolean bl = obj == this || obj != null && obj.getClass() == this.getClass() && this.originalSerializer.equals(obj);
            return bl;
        }
    }

    @Override
    public int hashCode() {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            int n = this.originalSerializer.hashCode();
            return n;
        }
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            SingleThreadAccessCheckingTypeSerializerSnapshot singleThreadAccessCheckingTypeSerializerSnapshot = new SingleThreadAccessCheckingTypeSerializerSnapshot(this);
            return singleThreadAccessCheckingTypeSerializerSnapshot;
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        try (SingleThreadAccessCheck ignored = this.singleThreadAccessChecker.startSingleThreadAccessCheck();){
            outputStream.defaultWriteObject();
        }
    }

    private static class SingleThreadAccessCheck
    implements AutoCloseable {
        private final AtomicReference<Thread> currentThreadRef;

        private SingleThreadAccessCheck(AtomicReference<Thread> currentThreadRef) {
            this.currentThreadRef = currentThreadRef;
        }

        @Override
        public void close() {
            assert (this.currentThreadRef.compareAndSet(Thread.currentThread(), null)) : "The checker has concurrent access from " + this.currentThreadRef.get();
        }
    }

    private static class SingleThreadAccessChecker
    implements Serializable {
        private static final long serialVersionUID = 131020282727167064L;
        private transient AtomicReference<Thread> currentThreadRef = new AtomicReference();

        private SingleThreadAccessChecker() {
        }

        SingleThreadAccessCheck startSingleThreadAccessCheck() {
            assert (this.currentThreadRef.compareAndSet(null, Thread.currentThread())) : "The checker has concurrent access from " + this.currentThreadRef.get();
            return new SingleThreadAccessCheck(this.currentThreadRef);
        }

        private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
            inputStream.defaultReadObject();
            this.currentThreadRef = new AtomicReference();
        }
    }

    public static class SingleThreadAccessCheckingTypeSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<T, SingleThreadAccessCheckingTypeSerializer<T>> {
        public SingleThreadAccessCheckingTypeSerializerSnapshot() {
        }

        SingleThreadAccessCheckingTypeSerializerSnapshot(SingleThreadAccessCheckingTypeSerializer<T> serializerInstance) {
            super(serializerInstance);
        }

        @Override
        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        @Override
        protected TypeSerializer<?>[] getNestedSerializers(SingleThreadAccessCheckingTypeSerializer<T> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.originalSerializer};
        }

        @Override
        protected SingleThreadAccessCheckingTypeSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new SingleThreadAccessCheckingTypeSerializer(nestedSerializers[0]);
        }
    }
}

