/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filemerging;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.PhysicalStateHandleID;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;

public class DirectoryStreamStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 1L;
    private final Path directory;

    public DirectoryStreamStateHandle(@Nonnull Path directory) {
        this.directory = directory;
    }

    @Override
    public FSDataInputStream openInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        return Optional.empty();
    }

    @Override
    public PhysicalStateHandleID getStreamStateHandleID() {
        return new PhysicalStateHandleID(this.directory.toString());
    }

    public SharedStateRegistryKey createStateRegistryKey() {
        return new SharedStateRegistryKey(this.directory.toString());
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryStreamStateHandle that = (DirectoryStreamStateHandle)o;
        return this.directory.equals(that.directory);
    }

    public String toString() {
        return "DirectoryStreamStateHandle{directory=" + this.getDirectory() + '}';
    }

    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public void discardState() throws Exception {
        FileSystem fs = this.directory.getFileSystem();
        fs.delete(this.directory, true);
    }

    @Override
    public long getStateSize() {
        return 0L;
    }

    public static DirectoryStreamStateHandle of(@Nonnull Path directory) {
        return new DirectoryStreamStateHandle(directory);
    }
}

