/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.util.MutableObjectIterator;

public class MapDriver<IT, OT>
implements Driver<MapFunction<IT, OT>, OT> {
    private TaskContext<MapFunction<IT, OT>, OT> taskContext;
    private volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<MapFunction<IT, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<MapFunction<IT, OT>> getStubType() {
        Class<MapFunction> clazz = MapFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        Counter numRecordsIn = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsInCounter();
        Counter numRecordsOut = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        MutableObjectIterator input = this.taskContext.getInput(0);
        MapFunction<IT, OT> function = this.taskContext.getStub();
        CountingCollector<OT> output = new CountingCollector<OT>(this.taskContext.getOutputCollector(), numRecordsOut);
        if (this.objectReuseEnabled) {
            Object record = this.taskContext.getInputSerializer(0).getSerializer().createInstance();
            while (this.running && (record = input.next(record)) != null) {
                numRecordsIn.inc();
                output.collect(function.map(record));
            }
        } else {
            Object record = null;
            while (this.running) {
                Object x = input.next();
                record = x;
                if (x != null) {
                    numRecordsIn.inc();
                    output.collect(function.map(record));
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

