/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class CheckpointStatsHistory
implements Serializable {
    private static final long serialVersionUID = 7090320677606528415L;
    private final List<AbstractCheckpointStats> checkpointsHistory;
    private final LinkedHashMap<Long, AbstractCheckpointStats> recentCheckpoints;
    private final int maxSize;
    private final boolean readOnly;
    private transient AbstractCheckpointStats[] checkpointsArray;
    private transient int nextPos;
    @Nullable
    private CompletedCheckpointStats latestCompletedCheckpoint;
    @Nullable
    private FailedCheckpointStats latestFailedCheckpoint;
    @Nullable
    private CompletedCheckpointStats latestSavepoint;

    CheckpointStatsHistory(int maxSize) {
        this(false, maxSize, new AbstractCheckpointStats[0], Collections.emptyList(), Collections.emptyMap(), null, null, null);
    }

    private CheckpointStatsHistory(boolean readOnly, final int maxSize, AbstractCheckpointStats[] checkpointArray, List<AbstractCheckpointStats> checkpointsHistory, Map<Long, AbstractCheckpointStats> checkpointsById, @Nullable CompletedCheckpointStats latestCompletedCheckpoint, @Nullable FailedCheckpointStats latestFailedCheckpoint, @Nullable CompletedCheckpointStats latestSavepoint) {
        this.readOnly = readOnly;
        Preconditions.checkArgument(maxSize >= 0, "Negative maximum size");
        this.maxSize = maxSize;
        this.checkpointsArray = checkpointArray;
        this.checkpointsHistory = Preconditions.checkNotNull(checkpointsHistory);
        this.latestCompletedCheckpoint = latestCompletedCheckpoint;
        this.latestFailedCheckpoint = latestFailedCheckpoint;
        this.latestSavepoint = latestSavepoint;
        this.recentCheckpoints = new LinkedHashMap<Long, AbstractCheckpointStats>(checkpointsById){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > maxSize;
            }
        };
    }

    public List<AbstractCheckpointStats> getCheckpoints() {
        return this.checkpointsHistory;
    }

    public AbstractCheckpointStats getCheckpointById(long checkpointId) {
        return this.recentCheckpoints.get(checkpointId);
    }

    @Nullable
    public CompletedCheckpointStats getLatestCompletedCheckpoint() {
        return this.latestCompletedCheckpoint;
    }

    @Nullable
    public FailedCheckpointStats getLatestFailedCheckpoint() {
        return this.latestFailedCheckpoint;
    }

    @Nullable
    public CompletedCheckpointStats getLatestSavepoint() {
        return this.latestSavepoint;
    }

    CheckpointStatsHistory createSnapshot() {
        List<AbstractCheckpointStats> checkpointsHistory;
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create a snapshot of a read-only history.");
        }
        HashMap<Long, AbstractCheckpointStats> checkpointsById = CollectionUtil.newHashMapWithExpectedSize(this.checkpointsArray.length);
        if (this.maxSize == 0) {
            checkpointsHistory = Collections.emptyList();
        } else {
            AbstractCheckpointStats[] newCheckpointsArray = new AbstractCheckpointStats[this.checkpointsArray.length];
            System.arraycopy(this.checkpointsArray, this.nextPos, newCheckpointsArray, 0, this.checkpointsArray.length - this.nextPos);
            System.arraycopy(this.checkpointsArray, 0, newCheckpointsArray, this.checkpointsArray.length - this.nextPos, this.nextPos);
            checkpointsHistory = Arrays.asList(newCheckpointsArray);
            Collections.reverse(checkpointsHistory);
            for (AbstractCheckpointStats checkpoint : checkpointsHistory) {
                checkpointsById.put(checkpoint.getCheckpointId(), checkpoint);
            }
        }
        if (this.latestCompletedCheckpoint != null) {
            checkpointsById.put(this.latestCompletedCheckpoint.getCheckpointId(), this.latestCompletedCheckpoint);
        }
        if (this.latestFailedCheckpoint != null) {
            checkpointsById.put(this.latestFailedCheckpoint.getCheckpointId(), this.latestFailedCheckpoint);
        }
        if (this.latestSavepoint != null) {
            checkpointsById.put(this.latestSavepoint.getCheckpointId(), this.latestSavepoint);
        }
        return new CheckpointStatsHistory(true, this.maxSize, null, checkpointsHistory, checkpointsById, this.latestCompletedCheckpoint, this.latestFailedCheckpoint, this.latestSavepoint);
    }

    void addInProgressCheckpoint(PendingCheckpointStats pending) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create a snapshot of a read-only history.");
        }
        if (this.maxSize == 0) {
            return;
        }
        Preconditions.checkNotNull(pending, "Pending checkpoint");
        if (this.checkpointsArray.length < this.maxSize) {
            this.checkpointsArray = Arrays.copyOf(this.checkpointsArray, this.checkpointsArray.length + 1);
        }
        if (this.nextPos == this.checkpointsArray.length) {
            this.nextPos = 0;
        }
        this.checkpointsArray[this.nextPos++] = pending;
        this.recentCheckpoints.put(pending.checkpointId, pending);
    }

    boolean replacePendingCheckpointById(AbstractCheckpointStats completedOrFailed) {
        int startPos;
        int i;
        Preconditions.checkArgument(!completedOrFailed.getStatus().isInProgress(), "Not allowed to replace with in progress checkpoints.");
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create a snapshot of a read-only history.");
        }
        if (completedOrFailed.getStatus().isCompleted()) {
            CompletedCheckpointStats completed = (CompletedCheckpointStats)completedOrFailed;
            if (completed.getProperties().isSavepoint() && (this.latestSavepoint == null || completed.getCheckpointId() > this.latestSavepoint.getCheckpointId())) {
                this.latestSavepoint = completed;
            } else if (this.latestCompletedCheckpoint == null || completed.getCheckpointId() > this.latestCompletedCheckpoint.getCheckpointId()) {
                this.latestCompletedCheckpoint = completed;
            }
        } else if (completedOrFailed.getStatus().isFailed()) {
            FailedCheckpointStats failed = (FailedCheckpointStats)completedOrFailed;
            if (this.latestFailedCheckpoint == null || failed.getCheckpointId() > this.latestFailedCheckpoint.getCheckpointId()) {
                this.latestFailedCheckpoint = failed;
            }
        }
        if (this.maxSize == 0) {
            return false;
        }
        long checkpointId = completedOrFailed.getCheckpointId();
        this.recentCheckpoints.computeIfPresent(checkpointId, (unusedKey, unusedValue) -> completedOrFailed);
        for (i = startPos = this.nextPos == this.checkpointsArray.length ? this.checkpointsArray.length - 1 : this.nextPos - 1; i >= 0; --i) {
            if (this.checkpointsArray[i].getCheckpointId() != checkpointId) continue;
            this.checkpointsArray[i] = completedOrFailed;
            return true;
        }
        for (i = this.checkpointsArray.length - 1; i > startPos; --i) {
            if (this.checkpointsArray[i].getCheckpointId() != checkpointId) continue;
            this.checkpointsArray[i] = completedOrFailed;
            return true;
        }
        return false;
    }
}

