/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.ListDelimitedSerializer;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RestoreOperation;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.heap.HeapMetaInfoRestoreOperation;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSet;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSnapshotRestoreWrapper;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.heap.StateTableFactory;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.restore.FullSnapshotRestoreOperation;
import org.apache.flink.runtime.state.restore.KeyGroup;
import org.apache.flink.runtime.state.restore.KeyGroupEntry;
import org.apache.flink.runtime.state.restore.SavepointRestoreResult;
import org.apache.flink.runtime.state.restore.ThrowingIterator;

public class HeapSavepointRestoreOperation<K>
implements RestoreOperation<Void> {
    private final int keyGroupPrefixBytes;
    private final StateSerializerProvider<K> keySerializerProvider;
    private final Map<String, StateTable<K, ?, ?>> registeredKVStates;
    private final Map<String, HeapPriorityQueueSnapshotRestoreWrapper<?>> registeredPQStates;
    private final FullSnapshotRestoreOperation<K> savepointRestoreOperation;
    private final HeapMetaInfoRestoreOperation<K> heapMetaInfoRestoreOperation;
    private final DataInputDeserializer entryKeyDeserializer;
    private final DataInputDeserializer entryValueDeserializer;
    private final ListDelimitedSerializer listDelimitedSerializer;

    HeapSavepointRestoreOperation(@Nonnull Collection<KeyedStateHandle> restoreStateHandles, StateSerializerProvider<K> keySerializerProvider, ClassLoader userCodeClassLoader, Map<String, StateTable<K, ?, ?>> registeredKVStates, Map<String, HeapPriorityQueueSnapshotRestoreWrapper<?>> registeredPQStates, HeapPriorityQueueSetFactory priorityQueueSetFactory, @Nonnull KeyGroupRange keyGroupRange, int numberOfKeyGroups, StateTableFactory<K> stateTableFactory, InternalKeyContext<K> keyContext) {
        this.keySerializerProvider = keySerializerProvider;
        this.registeredKVStates = registeredKVStates;
        this.registeredPQStates = registeredPQStates;
        this.savepointRestoreOperation = new FullSnapshotRestoreOperation<K>(keyGroupRange, userCodeClassLoader, restoreStateHandles, keySerializerProvider);
        this.keyGroupPrefixBytes = CompositeKeySerializationUtils.computeRequiredBytesInKeyGroupPrefix(numberOfKeyGroups);
        this.heapMetaInfoRestoreOperation = new HeapMetaInfoRestoreOperation<K>(keySerializerProvider, priorityQueueSetFactory, keyGroupRange, numberOfKeyGroups, stateTableFactory, keyContext);
        this.entryKeyDeserializer = new DataInputDeserializer();
        this.entryValueDeserializer = new DataInputDeserializer();
        this.listDelimitedSerializer = new ListDelimitedSerializer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void restore() throws Exception {
        this.registeredKVStates.clear();
        this.registeredPQStates.clear();
        try (Object restore = this.savepointRestoreOperation.restore();){
            while (restore.hasNext()) {
                ThrowingIterator<KeyGroup> keyGroups;
                block23: {
                    SavepointRestoreResult restoreResult = (SavepointRestoreResult)restore.next();
                    List<StateMetaInfoSnapshot> restoredMetaInfos = restoreResult.getStateMetaInfoSnapshots();
                    Map<Integer, StateMetaInfoSnapshot> kvStatesById = this.heapMetaInfoRestoreOperation.createOrCheckStateForMetaInfo(restoredMetaInfos, this.registeredKVStates, this.registeredPQStates);
                    keyGroups = restoreResult.getRestoredKeyGroups();
                    Throwable throwable = null;
                    try {
                        while (keyGroups.hasNext()) {
                            this.readKeyGroupStateData(keyGroups.next(), this.keySerializerProvider.previousSchemaSerializer(), kvStatesById);
                        }
                        if (keyGroups == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (keyGroups == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    keyGroups.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            keyGroups.close();
                            throw throwable3;
                        }
                    }
                    try {
                        keyGroups.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                keyGroups.close();
            }
            return null;
        }
    }

    private void readKeyGroupStateData(KeyGroup keyGroup, TypeSerializer<K> keySerializer, Map<Integer, StateMetaInfoSnapshot> kvStatesById) throws Exception {
        try (ThrowingIterator<KeyGroupEntry> entries = keyGroup.getKeyGroupEntries();){
            while (entries.hasNext()) {
                KeyGroupEntry groupEntry = entries.next();
                StateMetaInfoSnapshot infoSnapshot = kvStatesById.get(groupEntry.getKvStateId());
                switch (infoSnapshot.getBackendStateType()) {
                    case KEY_VALUE: {
                        this.readKVStateData(keySerializer, groupEntry, infoSnapshot);
                        break;
                    }
                    case PRIORITY_QUEUE: {
                        this.readPriorityQueue(groupEntry, infoSnapshot);
                        break;
                    }
                    case OPERATOR: 
                    case BROADCAST: {
                        throw new IllegalStateException("Expected only keyed state. Received: " + (Object)((Object)infoSnapshot.getBackendStateType()));
                    }
                }
            }
        }
    }

    private void readPriorityQueue(KeyGroupEntry groupEntry, StateMetaInfoSnapshot infoSnapshot) throws IOException {
        this.entryKeyDeserializer.setBuffer(groupEntry.getKey());
        this.entryKeyDeserializer.skipBytesToRead(this.keyGroupPrefixBytes);
        HeapPriorityQueueSnapshotRestoreWrapper<?> priorityQueueSnapshotRestoreWrapper = this.registeredPQStates.get(infoSnapshot.getName());
        HeapPriorityQueueElement timer = (HeapPriorityQueueElement)priorityQueueSnapshotRestoreWrapper.getMetaInfo().getElementSerializer().deserialize(this.entryKeyDeserializer);
        HeapPriorityQueueSet<?> priorityQueue = priorityQueueSnapshotRestoreWrapper.getPriorityQueue();
        priorityQueue.add(timer);
    }

    private void readKVStateData(TypeSerializer<K> keySerializer, KeyGroupEntry groupEntry, StateMetaInfoSnapshot infoSnapshot) throws IOException {
        StateTable<K, ?, ?> stateTable = this.registeredKVStates.get(infoSnapshot.getName());
        RegisteredKeyValueStateBackendMetaInfo<?, ?> metaInfo = stateTable.getMetaInfo();
        TypeSerializer<?> namespaceSerializer = metaInfo.getPreviousNamespaceSerializer();
        TypeSerializer<?> stateSerializer = metaInfo.getPreviousStateSerializer();
        boolean isAmbigousKey = keySerializer.getLength() < 0 && namespaceSerializer.getLength() < 0;
        this.entryKeyDeserializer.setBuffer(groupEntry.getKey());
        this.entryValueDeserializer.setBuffer(groupEntry.getValue());
        int keyGroup = CompositeKeySerializationUtils.readKeyGroup(this.keyGroupPrefixBytes, this.entryKeyDeserializer);
        K key = CompositeKeySerializationUtils.readKey(keySerializer, this.entryKeyDeserializer, isAmbigousKey);
        Object namespace = CompositeKeySerializationUtils.readNamespace(namespaceSerializer, this.entryKeyDeserializer, isAmbigousKey);
        switch (metaInfo.getStateType()) {
            case LIST: {
                stateTable.put(key, keyGroup, namespace, this.listDelimitedSerializer.deserializeList(groupEntry.getValue(), ((ListSerializer)stateSerializer).getElementSerializer()));
                break;
            }
            case VALUE: 
            case REDUCING: 
            case FOLDING: 
            case AGGREGATING: {
                stateTable.put(key, keyGroup, namespace, stateSerializer.deserialize(this.entryValueDeserializer));
                break;
            }
            case MAP: {
                this.deserializeMapStateEntry(stateTable, keyGroup, key, namespace, (MapSerializer)stateSerializer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state type: " + (Object)((Object)metaInfo.getStateType()));
            }
        }
    }

    private void deserializeMapStateEntry(StateTable<K, Object, Map<Object, Object>> stateTable, int keyGroup, K key, Object namespace, MapSerializer<Object, Object> stateSerializer) throws IOException {
        Object mapEntryKey = stateSerializer.getKeySerializer().deserialize(this.entryKeyDeserializer);
        boolean isNull = this.entryValueDeserializer.readBoolean();
        Object mapEntryValue = isNull ? null : stateSerializer.getValueSerializer().deserialize(this.entryValueDeserializer);
        Map<Object, Object> userMap = stateTable.get(key, namespace);
        if (userMap == null) {
            userMap = new HashMap<Object, Object>();
            stateTable.put(key, keyGroup, namespace, userMap);
        }
        userMap.put(mapEntryKey, mapEntryValue);
    }
}

