/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.Preconditions;

public class PendingTaskManager {
    private final PendingTaskManagerId pendingTaskManagerId;
    private final ResourceProfile totalResourceProfile;
    private final ResourceProfile defaultSlotResourceProfile;
    private final int numSlots;
    private ResourceProfile unusedResource;
    Map<JobID, ResourceCounter> pendingSlotAllocationRecords;

    public PendingTaskManager(ResourceProfile totalResourceProfile, int numSlots) {
        this.numSlots = numSlots;
        this.totalResourceProfile = Preconditions.checkNotNull(totalResourceProfile);
        this.defaultSlotResourceProfile = SlotManagerUtils.generateDefaultSlotResourceProfile(totalResourceProfile, numSlots);
        this.pendingTaskManagerId = PendingTaskManagerId.generate();
        this.unusedResource = totalResourceProfile;
        this.pendingSlotAllocationRecords = new HashMap<JobID, ResourceCounter>();
    }

    public ResourceProfile getTotalResourceProfile() {
        return this.totalResourceProfile;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public PendingTaskManagerId getPendingTaskManagerId() {
        return this.pendingTaskManagerId;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public ResourceProfile getUnusedResource() {
        return this.unusedResource;
    }

    public Map<JobID, ResourceCounter> getPendingSlotAllocationRecords() {
        return this.pendingSlotAllocationRecords;
    }

    public void clearAllPendingAllocations() {
        this.pendingSlotAllocationRecords.clear();
        this.unusedResource = this.totalResourceProfile;
    }

    public void replaceAllPendingAllocations(Map<JobID, ResourceCounter> pendingSlotAllocations) {
        this.pendingSlotAllocationRecords.clear();
        this.pendingSlotAllocationRecords.putAll(pendingSlotAllocations);
        this.unusedResource = this.calculateUnusedResourceProfile();
    }

    public void clearPendingAllocationsOfJob(JobID jobId) {
        Optional.ofNullable(this.pendingSlotAllocationRecords.remove(jobId)).ifPresent(resourceCounter -> {
            this.unusedResource = this.unusedResource.merge(resourceCounter.getTotalResource());
        });
    }

    private ResourceProfile calculateUnusedResourceProfile() {
        return this.totalResourceProfile.subtract(this.pendingSlotAllocationRecords.values().stream().map(ResourceCounter::getTotalResource).reduce(ResourceProfile.ZERO, ResourceProfile::merge));
    }

    public String toString() {
        return String.format("PendingTaskManager{id=%s, totalResourceProfile=%s, defaultSlotResourceProfile=%s}", this.pendingTaskManagerId, this.totalResourceProfile, this.defaultSlotResourceProfile);
    }
}

