/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.io.network.metrics.ResultPartitionBytesCounter;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class TaskIOMetricGroup
extends ProxyMetricGroup<TaskMetricGroup> {
    private static final long INVALID_TIMESTAMP = -1L;
    private final Clock clock;
    private final Counter numBytesIn;
    private final Counter numBytesOut;
    private final SumCounter numRecordsIn;
    private final SumCounter numRecordsOut;
    private final Counter numBuffersOut;
    private final Counter numFiredTimers;
    private final MeterView numFiredTimersRate;
    private final Counter numMailsProcessed;
    private final Meter numBytesInRate;
    private final Meter numBytesOutRate;
    private final Meter numRecordsInRate;
    private final Meter numRecordsOutRate;
    private final Meter numBuffersOutRate;
    private final TimerGauge idleTimePerSecond;
    private final Gauge<Double> busyTimePerSecond;
    private final Gauge<Long> backPressuredTimePerSecond;
    private final TimerGauge softBackPressuredTimePerSecond;
    private final TimerGauge hardBackPressuredTimePerSecond;
    private final TimerGauge changelogBusyTimeMsPerSecond;
    private final Gauge<Long> maxSoftBackPressuredTime;
    private final Gauge<Long> maxHardBackPressuredTime;
    private final Gauge<Long> accumulatedBackPressuredTime;
    private final Gauge<Long> accumulatedIdleTime;
    private final Gauge<Double> accumulatedBusyTime;
    private final Meter mailboxThroughput;
    private final Histogram mailboxLatency;
    private final SizeGauge mailboxSize;
    private final Counter initializationDuration;
    private volatile boolean busyTimeEnabled;
    private long taskStartTime;
    private long taskInitializeTime;
    private final Map<IntermediateResultPartitionID, ResultPartitionBytesCounter> resultPartitionBytes = new HashMap<IntermediateResultPartitionID, ResultPartitionBytesCounter>();

    public TaskIOMetricGroup(TaskMetricGroup parent) {
        this(parent, SystemClock.getInstance());
    }

    public TaskIOMetricGroup(TaskMetricGroup parent, Clock clock) {
        super(parent);
        this.clock = clock;
        this.numBytesIn = this.counter("numBytesIn");
        this.numBytesOut = this.counter("numBytesOut");
        this.numBytesInRate = this.meter("numBytesInPerSecond", new MeterView(this.numBytesIn));
        this.numBytesOutRate = this.meter("numBytesOutPerSecond", new MeterView(this.numBytesOut));
        this.numRecordsIn = this.counter("numRecordsIn", new SumCounter());
        this.numRecordsOut = this.counter("numRecordsOut", new SumCounter());
        this.numRecordsInRate = this.meter("numRecordsInPerSecond", new MeterView((Counter)this.numRecordsIn));
        this.numRecordsOutRate = this.meter("numRecordsOutPerSecond", new MeterView((Counter)this.numRecordsOut));
        this.numBuffersOut = this.counter("numBuffersOut");
        this.numBuffersOutRate = this.meter("numBuffersOutPerSecond", new MeterView(this.numBuffersOut));
        this.idleTimePerSecond = this.gauge("idleTimeMsPerSecond", new TimerGauge(clock));
        this.softBackPressuredTimePerSecond = this.gauge("softBackPressuredTimeMsPerSecond", new TimerGauge(clock));
        this.hardBackPressuredTimePerSecond = this.gauge("hardBackPressuredTimeMsPerSecond", new TimerGauge(clock));
        this.backPressuredTimePerSecond = this.gauge("backPressuredTimeMsPerSecond", this::getBackPressuredTimeMsPerSecond);
        this.maxSoftBackPressuredTime = this.gauge("maxSoftBackPressureTimeMs", this.softBackPressuredTimePerSecond::getMaxSingleMeasurement);
        this.maxHardBackPressuredTime = this.gauge("maxHardBackPressureTimeMs", this.hardBackPressuredTimePerSecond::getMaxSingleMeasurement);
        this.busyTimePerSecond = this.gauge("busyTimeMsPerSecond", this::getBusyTimePerSecond);
        this.changelogBusyTimeMsPerSecond = this.gauge("changelogBusyTimeMsPerSecond", new TimerGauge(clock));
        this.accumulatedBusyTime = this.gauge("accumulateBusyTimeMs", this::getAccumulatedBusyTime);
        this.accumulatedBackPressuredTime = this.gauge("accumulateBackPressuredTimeMs", this::getAccumulatedBackPressuredTimeMs);
        this.accumulatedIdleTime = this.gauge("accumulateIdleTimeMs", this.idleTimePerSecond::getAccumulatedCount);
        this.numFiredTimers = this.counter("numFiredTimers", new SimpleCounter());
        this.numFiredTimersRate = this.meter("numFiredTimersPerSecond", new MeterView(this.numFiredTimers));
        this.numMailsProcessed = new SimpleCounter();
        this.mailboxThroughput = this.meter("mailboxMailsPerSecond", new MeterView(this.numMailsProcessed));
        this.mailboxLatency = this.histogram("mailboxLatencyMs", new DescriptiveStatisticsHistogram(60));
        this.mailboxSize = this.gauge("mailboxQueueSize", new SizeGauge());
        this.initializationDuration = this.counter("initializationTime", new Counter(){

            public void inc() {
            }

            public void inc(long n) {
            }

            public void dec() {
            }

            public void dec(long n) {
            }

            public long getCount() {
                return TaskIOMetricGroup.this.getTaskInitializationDuration();
            }
        });
        this.taskStartTime = -1L;
        this.taskInitializeTime = -1L;
    }

    public IOMetrics createSnapshot() {
        return new IOMetrics(this.numRecordsInRate, this.numRecordsOutRate, this.numBytesInRate, this.numBytesOutRate, this.accumulatedBackPressuredTime, this.accumulatedIdleTime, this.accumulatedBusyTime, this.resultPartitionBytes);
    }

    public Counter getNumBytesInCounter() {
        return this.numBytesIn;
    }

    public Counter getNumBytesOutCounter() {
        return this.numBytesOut;
    }

    public Counter getNumRecordsInCounter() {
        return this.numRecordsIn;
    }

    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOut;
    }

    public Counter getNumBuffersOutCounter() {
        return this.numBuffersOut;
    }

    public Counter getNumFiredTimers() {
        return this.numFiredTimers;
    }

    public Counter getNumMailsProcessedCounter() {
        return this.numMailsProcessed;
    }

    public TimerGauge getIdleTimeMsPerSecond() {
        return this.idleTimePerSecond;
    }

    public TimerGauge getSoftBackPressuredTimePerSecond() {
        return this.softBackPressuredTimePerSecond;
    }

    public TimerGauge getHardBackPressuredTimePerSecond() {
        return this.hardBackPressuredTimePerSecond;
    }

    public TimerGauge getChangelogBusyTimeMsPerSecond() {
        return this.changelogBusyTimeMsPerSecond;
    }

    public long getBackPressuredTimeMsPerSecond() {
        return this.getSoftBackPressuredTimePerSecond().getValue() + this.getHardBackPressuredTimePerSecond().getValue();
    }

    public long getAccumulatedBackPressuredTimeMs() {
        return this.getSoftBackPressuredTimePerSecond().getAccumulatedCount() + this.getHardBackPressuredTimePerSecond().getAccumulatedCount();
    }

    public void markTaskStart() {
        this.taskStartTime = this.clock.absoluteTimeMillis();
    }

    public void markTaskInitializationStarted() {
        if (this.taskInitializeTime == -1L) {
            this.taskInitializeTime = this.clock.absoluteTimeMillis();
        }
    }

    @VisibleForTesting
    public long getTaskInitializationDuration() {
        if (this.taskInitializeTime == -1L) {
            return 0L;
        }
        if (this.taskStartTime == -1L) {
            return this.clock.absoluteTimeMillis() - this.taskInitializeTime;
        }
        return this.taskStartTime - this.taskInitializeTime;
    }

    public void setEnableBusyTime(boolean enabled) {
        this.busyTimeEnabled = enabled;
    }

    @VisibleForTesting
    double getBusyTimePerSecond() {
        double busyTime = this.idleTimePerSecond.getValue() + this.getBackPressuredTimeMsPerSecond();
        return this.busyTimeEnabled ? 1000.0 - Math.min(busyTime, 1000.0) : Double.NaN;
    }

    @VisibleForTesting
    double getAccumulatedBusyTime() {
        if (!this.busyTimeEnabled) {
            return Double.NaN;
        }
        if (this.taskStartTime == -1L) {
            return Double.NaN;
        }
        return Math.max(this.clock.absoluteTimeMillis() - this.taskStartTime - this.idleTimePerSecond.getAccumulatedCount() - this.getAccumulatedBackPressuredTimeMs(), 0L);
    }

    public Meter getMailboxThroughput() {
        return this.mailboxThroughput;
    }

    public Histogram getMailboxLatency() {
        return this.mailboxLatency;
    }

    public Gauge<Integer> getMailboxSize() {
        return this.mailboxSize;
    }

    public void registerBackPressureListener(TimerGauge.StartStopListener backPressureListener) {
        this.hardBackPressuredTimePerSecond.registerListener(backPressureListener);
        this.softBackPressuredTimePerSecond.registerListener(backPressureListener);
    }

    public void unregisterBackPressureListener(TimerGauge.StartStopListener backPressureListener) {
        this.hardBackPressuredTimePerSecond.unregisterListener(backPressureListener);
        this.softBackPressuredTimePerSecond.unregisterListener(backPressureListener);
    }

    public void reuseRecordsInputCounter(Counter numRecordsInCounter) {
        this.numRecordsIn.addCounter(numRecordsInCounter);
    }

    public void reuseRecordsOutputCounter(Counter numRecordsOutCounter) {
        this.numRecordsOut.addCounter(numRecordsOutCounter);
    }

    public void registerResultPartitionBytesCounter(IntermediateResultPartitionID resultPartitionId, ResultPartitionBytesCounter resultPartitionBytesCounter) {
        this.resultPartitionBytes.put(resultPartitionId, resultPartitionBytesCounter);
    }

    public void registerMailboxSizeSupplier(SizeSupplier<Integer> supplier) {
        this.mailboxSize.registerSupplier(supplier);
    }

    @FunctionalInterface
    public static interface SizeSupplier<R> {
        public R get();
    }

    private static class SizeGauge
    implements Gauge<Integer> {
        private SizeSupplier<Integer> supplier;

        private SizeGauge() {
        }

        public void registerSupplier(SizeSupplier<Integer> supplier) {
            this.supplier = supplier;
        }

        public Integer getValue() {
            if (this.supplier != null) {
                return this.supplier.get();
            }
            return 0;
        }
    }

    private static class SumCounter
    extends SimpleCounter {
        private final List<Counter> internalCounters = new ArrayList<Counter>();

        SumCounter() {
        }

        public void addCounter(Counter toAdd) {
            this.internalCounters.add(toAdd);
        }

        public long getCount() {
            long sum = super.getCount();
            for (Counter counter : this.internalCounters) {
                sum += counter.getCount();
            }
            return sum;
        }
    }
}

