/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterOperation;
import org.apache.flink.util.Preconditions;

@Internal
public class AlterCatalogResetOperation
implements AlterOperation {
    private final String catalogName;
    private final Set<String> resetKeys;

    public AlterCatalogResetOperation(String catalogName, Set<String> resetKeys) {
        this.catalogName = Preconditions.checkNotNull(catalogName);
        this.resetKeys = Collections.unmodifiableSet(Preconditions.checkNotNull(resetKeys));
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Set<String> getResetKeys() {
        return this.resetKeys;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER CATALOG %s\n%s", this.catalogName, this.resetKeys.stream().map(key -> String.format("  RESET '%s'", key)).collect(Collectors.joining(",\n")));
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getCatalogManager().alterCatalog(this.catalogName, new CatalogChange.CatalogConfigurationChange(conf -> this.resetKeys.forEach(conf::removeKey)));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (CatalogException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

