/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.workflow.scheduler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Properties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.shaded.org.quartz.JobKey;
import org.apache.flink.util.jackson.JacksonMapperFactory;

public class QuartzSchedulerUtils {
    public static final String SCHEDULE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String QUARTZ_JOB_PREFIX = "quartz_job";
    public static final String QUARTZ_JOB_GROUP = "default_group";
    public static final String UNDERLINE = "_";
    public static final String WORKFLOW_INFO = "workflowInfo";
    private static final ObjectMapper OBJECT_MAPPER = JacksonMapperFactory.createObjectMapper();

    public static Properties initializeQuartzSchedulerConfig() {
        Properties properties = new Properties();
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.scheduler.instanceName", "FlinkQuartzScheduler");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.threadPool", "FlinkQuartzSchedulerThreadPool");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.scheduler.rmi.export", "false");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.scheduler.rmi.proxy", "false");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.threadPool.class", "org.apache.flink.table.shaded.org.quartz.simpl.SimpleThreadPool");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.threadPool.threadCount", "1");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.threadPool.threadPriority", "5");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", "true");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", "true");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.jobStore.misfireThreshold", "60000");
        properties.setProperty("org.apache.flink.table.shaded.org.quartz.jobStore.class", "org.apache.flink.table.shaded.org.quartz.simpl.RAMJobStore");
        return properties;
    }

    public static JobKey getJobKey(String materializedTableIdentifier) {
        String jobName = "quartz_job_" + materializedTableIdentifier;
        return JobKey.jobKey(jobName, QUARTZ_JOB_GROUP);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to deserialize JSON string to %s: %s.", clazz.getSimpleName(), e.getMessage()), e);
        }
    }

    public static <T> String toJson(T t) {
        try {
            return OBJECT_MAPPER.writeValueAsString(t);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to serialize instance of %s to JSON string: %s.", t.getClass().getSimpleName(), e.getMessage()), e);
        }
    }

    public static String dateToString(Date date) {
        return QuartzSchedulerUtils.date2LocalDateTime(date).format(DEFAULT_DATETIME_FORMATTER);
    }

    private static LocalDateTime date2LocalDateTime(Date date) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
    }
}

