/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filemerging;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filemerging.DirectoryStreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMergingOperatorStreamStateHandle
extends OperatorStreamStateHandle
implements CompositeStateHandle {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FileMergingOperatorStreamStateHandle.class);
    private final DirectoryStreamStateHandle taskOwnedDirHandle;
    private final DirectoryStreamStateHandle sharedDirHandle;
    private transient SharedStateRegistry sharedStateRegistry;

    public FileMergingOperatorStreamStateHandle(DirectoryStreamStateHandle taskOwnedDirHandle, DirectoryStreamStateHandle sharedDirHandle, Map<String, OperatorStateHandle.StateMetaInfo> stateNameToPartitionOffsets, StreamStateHandle delegateStateHandle) {
        super(stateNameToPartitionOffsets, delegateStateHandle);
        this.taskOwnedDirHandle = taskOwnedDirHandle;
        this.sharedDirHandle = sharedDirHandle;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointId) {
        Preconditions.checkState(this.sharedStateRegistry != stateRegistry, "The state handle has already registered its shared states to the given registry.");
        this.sharedStateRegistry = Preconditions.checkNotNull(stateRegistry);
        LOG.trace("Registering FileMergingOperatorStreamStateHandle for checkpoint {} from backend.", (Object)checkpointId);
        stateRegistry.registerReference(this.taskOwnedDirHandle.createStateRegistryKey(), this.taskOwnedDirHandle, checkpointId);
        stateRegistry.registerReference(this.sharedDirHandle.createStateRegistryKey(), this.sharedDirHandle, checkpointId);
    }

    @Override
    public void discardState() throws Exception {
        SharedStateRegistry registry = this.sharedStateRegistry;
        boolean isRegistered = registry != null;
        LOG.trace("Discarding FileMergingOperatorStreamStateHandle (registered = {}) from backend.", (Object)isRegistered);
        try {
            this.getDelegateStateHandle().discardState();
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard directory state handle.", (Throwable)e);
        }
    }

    @Override
    public long getCheckpointedSize() {
        return this.getDelegateStateHandle().getStateSize();
    }

    public DirectoryStreamStateHandle getSharedDirHandle() {
        return this.sharedDirHandle;
    }

    public DirectoryStreamStateHandle getTaskOwnedDirHandle() {
        return this.taskOwnedDirHandle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMergingOperatorStreamStateHandle that = (FileMergingOperatorStreamStateHandle)o;
        return super.equals(that) && this.taskOwnedDirHandle.equals(that.taskOwnedDirHandle) && this.sharedDirHandle.equals(that.sharedDirHandle);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.taskOwnedDirHandle);
        result = 31 * result + Objects.hashCode(this.sharedDirHandle);
        return result;
    }

    @Override
    public String toString() {
        return "FileMergingOperatorStreamStateHandle{" + super.toString() + ", taskOwnedDirHandle=" + this.taskOwnedDirHandle + ", sharedDirHandle=" + this.sharedDirHandle + '}';
    }
}

