/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.StreamStateHandle;

public interface CheckpointStreamFactory {
    public CheckpointStateOutputStream createCheckpointStateOutputStream(CheckpointedStateScope var1) throws IOException;

    public boolean canFastDuplicate(StreamStateHandle var1, CheckpointedStateScope var2) throws IOException;

    public List<StreamStateHandle> duplicate(List<StreamStateHandle> var1, CheckpointedStateScope var2) throws IOException;

    default public void reusePreviousStateHandle(Collection<? extends StreamStateHandle> previousHandle) {
    }

    default public boolean couldReuseStateHandle(StreamStateHandle stateHandle) {
        return !FileMergingSnapshotManager.isFileMergingHandle(stateHandle);
    }
}

