/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.Preconditions;

public class ChainedStateHandle<T extends StateObject>
implements StateObject {
    private static final long serialVersionUID = 1L;
    private final List<? extends T> operatorStateHandles;

    public ChainedStateHandle(List<? extends T> operatorStateHandles) {
        this.operatorStateHandles = Preconditions.checkNotNull(operatorStateHandles);
    }

    public boolean isEmpty() {
        for (StateObject state : this.operatorStateHandles) {
            if (state == null) continue;
            return false;
        }
        return true;
    }

    public int getLength() {
        return this.operatorStateHandles.size();
    }

    public T get(int index) {
        return (T)((StateObject)this.operatorStateHandles.get(index));
    }

    @Override
    public void discardState() throws Exception {
        StateUtil.bestEffortDiscardAllStateObjects(this.operatorStateHandles);
    }

    @Override
    public long getStateSize() {
        return this.streamInternalHandles().mapToLong(StateObject::getStateSize).sum();
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        this.streamInternalHandles().forEach(handle -> handle.collectSizeStats(collector));
    }

    private Stream<? extends T> streamInternalHandles() {
        if (this.operatorStateHandles.isEmpty()) {
            return Stream.empty();
        }
        return this.operatorStateHandles.stream().filter(Objects::nonNull);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainedStateHandle that = (ChainedStateHandle)o;
        return this.operatorStateHandles.equals(that.operatorStateHandles);
    }

    public int hashCode() {
        return this.operatorStateHandles.hashCode();
    }

    public static <T extends StateObject> ChainedStateHandle<T> wrapSingleHandle(T stateHandleToWrap) {
        return new ChainedStateHandle<T>(Collections.singletonList(stateHandleToWrap));
    }

    public static boolean isNullOrEmpty(ChainedStateHandle<?> chainedStateHandle) {
        return chainedStateHandle == null || chainedStateHandle.isEmpty();
    }
}

