/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.hadoop.HadoopUserUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.security.token.hadoop.KerberosLoginProvider;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopModule
implements SecurityModule {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopModule.class);
    private final SecurityConfiguration securityConfig;
    private final Configuration hadoopConfiguration;
    @Nullable
    private ScheduledExecutorService tgtRenewalExecutorService;

    public HadoopModule(SecurityConfiguration securityConfiguration, Configuration hadoopConfiguration) {
        this.securityConfig = Preconditions.checkNotNull(securityConfiguration);
        this.hadoopConfiguration = Preconditions.checkNotNull(hadoopConfiguration);
    }

    @VisibleForTesting
    public SecurityConfiguration getSecurityConfig() {
        return this.securityConfig;
    }

    @Override
    public void install() throws SecurityModule.SecurityInstallException {
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConfiguration);
        try {
            UserGroupInformation loginUser;
            KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(this.securityConfig);
            if (kerberosLoginProvider.isLoginPossible(true)) {
                kerberosLoginProvider.doLogin(true);
                loginUser = UserGroupInformation.getLoginUser();
                if (HadoopUserUtils.isProxyUser(loginUser) && this.securityConfig.getFlinkConfig().get(SecurityOptions.DELEGATION_TOKENS_ENABLED).booleanValue()) {
                    throw new UnsupportedOperationException("Hadoop Proxy user is supported only when delegation tokens fetch is managed outside of Flink! Please try again with " + SecurityOptions.DELEGATION_TOKENS_ENABLED.key() + " config set to false!");
                }
                if (loginUser.isFromKeytab()) {
                    String fileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
                    if (fileLocation != null) {
                        Credentials credentials = Credentials.readTokenStorageFile((File)new File(fileLocation), (Configuration)this.hadoopConfiguration);
                        loginUser.addCredentials(credentials);
                    }
                    this.tgtRenewalExecutorService = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory("TGTRenewalExecutorService"));
                    this.startTGTRenewal(this.tgtRenewalExecutorService, loginUser);
                }
            } else {
                loginUser = UserGroupInformation.getLoginUser();
            }
            LOG.info("Hadoop user set to {}", (Object)loginUser);
            boolean isKerberosSecurityEnabled = HadoopUserUtils.hasUserKerberosAuthMethod(loginUser);
            LOG.info("Kerberos security is {}.", (Object)(isKerberosSecurityEnabled ? "enabled" : "disabled"));
            if (isKerberosSecurityEnabled) {
                LOG.info("Kerberos credentials are {}.", (Object)(loginUser.hasKerberosCredentials() ? "valid" : "invalid"));
            }
        }
        catch (Throwable ex) {
            throw new SecurityModule.SecurityInstallException("Unable to set the Hadoop login user", ex);
        }
    }

    @VisibleForTesting
    void startTGTRenewal(ScheduledExecutorService tgtRenewalExecutorService, UserGroupInformation loginUser) {
        LOG.info("Starting TGT renewal task");
        long tgtRenewalPeriod = this.securityConfig.getTgtRenewalPeriod().toMillis();
        tgtRenewalExecutorService.scheduleAtFixedRate(() -> {
            try {
                LOG.debug("Renewing TGT");
                loginUser.checkTGTAndReloginFromKeytab();
                LOG.debug("TGT renewed successfully");
            }
            catch (Exception e) {
                LOG.warn("Error while renewing TGT", (Throwable)e);
            }
        }, tgtRenewalPeriod, tgtRenewalPeriod, TimeUnit.MILLISECONDS);
        LOG.info("TGT renewal task started and reoccur in {} ms", (Object)tgtRenewalPeriod);
    }

    @VisibleForTesting
    void stopTGTRenewal() {
        if (this.tgtRenewalExecutorService != null) {
            this.tgtRenewalExecutorService.shutdown();
            this.tgtRenewalExecutorService = null;
        }
    }

    @Override
    public void uninstall() {
        this.stopTGTRenewal();
    }
}

