/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.rest.messages.checkpoints.StatsSummaryDto;
import org.apache.flink.runtime.rest.messages.checkpoints.SubtaskCheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatistics;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public final class TaskCheckpointStatisticsWithSubtaskDetails
extends TaskCheckpointStatistics {
    public static final String FIELD_NAME_SUMMARY = "summary";
    public static final String FIELD_NAME_SUBTASKS_CHECKPOINT_STATISTICS = "subtasks";
    @JsonProperty(value="summary")
    private final Summary summary;
    @JsonProperty(value="subtasks")
    private final List<SubtaskCheckpointStatistics> subtaskCheckpointStatistics;

    @JsonCreator
    public TaskCheckpointStatisticsWithSubtaskDetails(@JsonProperty(value="id") long checkpointId, @JsonProperty(value="status") CheckpointStatsStatus checkpointStatus, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="checkpointed_size") long checkpointedSize, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="processed_data") long processedData, @JsonProperty(value="persisted_data") long persistedData, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonProperty(value="summary") Summary summary, @JsonProperty(value="subtasks") List<SubtaskCheckpointStatistics> subtaskCheckpointStatistics) {
        super(checkpointId, checkpointStatus, latestAckTimestamp, checkpointedSize, stateSize, duration, alignmentBuffered, processedData, persistedData, numSubtasks, numAckSubtasks);
        this.summary = Preconditions.checkNotNull(summary);
        this.subtaskCheckpointStatistics = Preconditions.checkNotNull(subtaskCheckpointStatistics);
    }

    public Summary getSummary() {
        return this.summary;
    }

    public List<SubtaskCheckpointStatistics> getSubtaskCheckpointStatistics() {
        return this.subtaskCheckpointStatistics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskCheckpointStatisticsWithSubtaskDetails that = (TaskCheckpointStatisticsWithSubtaskDetails)o;
        return Objects.equals(this.summary, that.summary) && Objects.equals(this.subtaskCheckpointStatistics, that.subtaskCheckpointStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.summary, this.subtaskCheckpointStatistics);
    }

    @Schema(name="CheckpointAlignmentSummary")
    public static final class CheckpointAlignment {
        public static final String FIELD_NAME_BUFFERED_DATA = "buffered";
        public static final String FIELD_NAME_PROCESSED = "processed";
        public static final String FIELD_NAME_PERSISTED = "persisted";
        public static final String FIELD_NAME_DURATION = "duration";
        @JsonProperty(value="buffered")
        private final StatsSummaryDto bufferedData;
        @JsonProperty(value="processed")
        private final StatsSummaryDto processedData;
        @JsonProperty(value="persisted")
        private final StatsSummaryDto persistedData;
        @JsonProperty(value="duration")
        private final StatsSummaryDto duration;

        @JsonCreator
        public CheckpointAlignment(@JsonProperty(value="buffered") StatsSummaryDto bufferedData, @JsonProperty(value="processed") StatsSummaryDto processedData, @JsonProperty(value="persisted") StatsSummaryDto persistedData, @JsonProperty(value="duration") StatsSummaryDto duration) {
            this.bufferedData = bufferedData;
            this.processedData = processedData;
            this.persistedData = persistedData;
            this.duration = duration;
        }

        public StatsSummaryDto getBufferedData() {
            return this.bufferedData;
        }

        public StatsSummaryDto getProcessedData() {
            return this.processedData;
        }

        public StatsSummaryDto getPersistedData() {
            return this.persistedData;
        }

        public StatsSummaryDto getDuration() {
            return this.duration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckpointAlignment alignment = (CheckpointAlignment)o;
            return Objects.equals(this.bufferedData, alignment.bufferedData) && Objects.equals(this.processedData, alignment.processedData) && Objects.equals(this.persistedData, alignment.persistedData) && Objects.equals(this.duration, alignment.duration);
        }

        public int hashCode() {
            return Objects.hash(this.bufferedData, this.processedData, this.persistedData, this.duration);
        }
    }

    @Schema(name="CheckpointDurationSummary")
    public static final class CheckpointDuration {
        public static final String FIELD_NAME_SYNCHRONOUS_DURATION = "sync";
        public static final String FIELD_NAME_ASYNCHRONOUS_DURATION = "async";
        @JsonProperty(value="sync")
        private final StatsSummaryDto synchronousDuration;
        @JsonProperty(value="async")
        private final StatsSummaryDto asynchronousDuration;

        @JsonCreator
        public CheckpointDuration(@JsonProperty(value="sync") StatsSummaryDto synchronousDuration, @JsonProperty(value="async") StatsSummaryDto asynchronousDuration) {
            this.synchronousDuration = Preconditions.checkNotNull(synchronousDuration);
            this.asynchronousDuration = Preconditions.checkNotNull(asynchronousDuration);
        }

        public StatsSummaryDto getSynchronousDuration() {
            return this.synchronousDuration;
        }

        public StatsSummaryDto getAsynchronousDuration() {
            return this.asynchronousDuration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckpointDuration that = (CheckpointDuration)o;
            return Objects.equals(this.synchronousDuration, that.synchronousDuration) && Objects.equals(this.asynchronousDuration, that.asynchronousDuration);
        }

        public int hashCode() {
            return Objects.hash(this.synchronousDuration, this.asynchronousDuration);
        }
    }

    @Schema(name="TaskCheckpointStatisticsWithSubtaskDetailsSummary")
    public static final class Summary {
        public static final String FIELD_NAME_CHECKPOINTED_SIZE = "checkpointed_size";
        public static final String FIELD_NAME_STATE_SIZE = "state_size";
        public static final String FIELD_NAME_DURATION = "end_to_end_duration";
        public static final String FIELD_NAME_CHECKPOINT_DURATION = "checkpoint_duration";
        public static final String FIELD_NAME_ALIGNMENT = "alignment";
        public static final String FIELD_NAME_START_DELAY = "start_delay";
        @JsonProperty(value="checkpointed_size")
        private final StatsSummaryDto checkpointedSize;
        @JsonProperty(value="state_size")
        private final StatsSummaryDto stateSize;
        @JsonProperty(value="end_to_end_duration")
        private final StatsSummaryDto duration;
        @JsonProperty(value="checkpoint_duration")
        private final CheckpointDuration checkpointDuration;
        @JsonProperty(value="alignment")
        private final CheckpointAlignment checkpointAlignment;
        @JsonProperty(value="start_delay")
        private final StatsSummaryDto checkpointStartDelay;

        @JsonCreator
        public Summary(@JsonProperty(value="checkpointed_size") StatsSummaryDto checkpointedSize, @JsonProperty(value="state_size") StatsSummaryDto stateSize, @JsonProperty(value="end_to_end_duration") StatsSummaryDto duration, @JsonProperty(value="checkpoint_duration") CheckpointDuration checkpointDuration, @JsonProperty(value="alignment") CheckpointAlignment checkpointAlignment, @JsonProperty(value="start_delay") StatsSummaryDto checkpointStartDelay) {
            this.checkpointedSize = Preconditions.checkNotNull(checkpointedSize);
            this.stateSize = Preconditions.checkNotNull(stateSize);
            this.duration = Preconditions.checkNotNull(duration);
            this.checkpointDuration = Preconditions.checkNotNull(checkpointDuration);
            this.checkpointAlignment = Preconditions.checkNotNull(checkpointAlignment);
            this.checkpointStartDelay = Preconditions.checkNotNull(checkpointStartDelay);
        }

        public StatsSummaryDto getCheckpointedSize() {
            return this.checkpointedSize;
        }

        public StatsSummaryDto getStateSize() {
            return this.stateSize;
        }

        public StatsSummaryDto getDuration() {
            return this.duration;
        }

        public CheckpointDuration getCheckpointDuration() {
            return this.checkpointDuration;
        }

        public CheckpointAlignment getCheckpointAlignment() {
            return this.checkpointAlignment;
        }

        public StatsSummaryDto getCheckpointStartDelay() {
            return this.checkpointStartDelay;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Summary summary = (Summary)o;
            return Objects.equals(this.checkpointedSize, summary.checkpointedSize) && Objects.equals(this.stateSize, summary.stateSize) && Objects.equals(this.duration, summary.duration) && Objects.equals(this.checkpointDuration, summary.checkpointDuration) && Objects.equals(this.checkpointAlignment, summary.checkpointAlignment) && Objects.equals(this.checkpointStartDelay, summary.checkpointStartDelay);
        }

        public int hashCode() {
            return Objects.hash(this.checkpointedSize, this.stateSize, this.duration, this.checkpointDuration, this.checkpointAlignment, this.checkpointStartDelay);
        }
    }
}

