/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import java.util.Map;
import org.apache.flink.runtime.executiongraph.JobVertexInputInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.event.JobEvent;
import org.apache.flink.util.Preconditions;

public class ExecutionJobVertexInitializedEvent
implements JobEvent {
    private final JobVertexID jobVertexId;
    private final int parallelism;
    private final Map<IntermediateDataSetID, JobVertexInputInfo> jobVertexInputInfos;

    public ExecutionJobVertexInitializedEvent(JobVertexID jobVertexId, int parallelism, Map<IntermediateDataSetID, JobVertexInputInfo> jobVertexInputInfos) {
        Preconditions.checkArgument(parallelism > 0);
        this.jobVertexId = Preconditions.checkNotNull(jobVertexId);
        this.parallelism = parallelism;
        this.jobVertexInputInfos = Preconditions.checkNotNull(jobVertexInputInfos);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public Map<IntermediateDataSetID, JobVertexInputInfo> getJobVertexInputInfos() {
        return this.jobVertexInputInfos;
    }

    public String toString() {
        return "ExecutionJobVertexInitializedEvent(jobVertexId='" + this.jobVertexId + "', parallelism='" + this.parallelism + "')";
    }
}

