/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class RemoteRecoveredInputChannel
extends RecoveredInputChannel {
    private final ConnectionID connectionId;
    private final ConnectionManager connectionManager;
    private final int partitionRequestListenerTimeout;

    RemoteRecoveredInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ResultSubpartitionIndexSet consumedSubpartitionIndexSet, ConnectionID connectionId, ConnectionManager connectionManager, int initialBackOff, int maxBackoff, int partitionRequestListenerTimeout, int networkBuffersPerChannel, InputChannelMetrics metrics) {
        super(inputGate, channelIndex, partitionId, consumedSubpartitionIndexSet, initialBackOff, maxBackoff, metrics.getNumBytesInRemoteCounter(), metrics.getNumBuffersInRemoteCounter(), networkBuffersPerChannel);
        this.connectionId = Preconditions.checkNotNull(connectionId);
        this.connectionManager = Preconditions.checkNotNull(connectionManager);
        this.partitionRequestListenerTimeout = partitionRequestListenerTimeout;
    }

    @Override
    protected InputChannel toInputChannelInternal() throws IOException {
        RemoteInputChannel remoteInputChannel = new RemoteInputChannel(this.inputGate, this.getChannelIndex(), this.partitionId, this.consumedSubpartitionIndexSet, this.connectionId, this.connectionManager, this.initialBackoff, this.maxBackoff, this.partitionRequestListenerTimeout, this.networkBuffersPerChannel, this.numBytesIn, this.numBuffersIn, this.channelStateWriter);
        remoteInputChannel.setup();
        return remoteInputChannel;
    }
}

