/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.RoundRobinSubpartitionSelector;
import org.apache.flink.runtime.io.network.partition.SubpartitionSelector;
import org.apache.flink.shaded.guava31.com.google.common.collect.BiMap;
import org.apache.flink.shaded.guava31.com.google.common.collect.HashBiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionResultSubpartitionView
implements ResultSubpartitionView,
BufferAvailabilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(UnionResultSubpartitionView.class);
    private static final int CACHE_CAPACITY = 10;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final BiMap<Integer, ResultSubpartitionView> allViews = HashBiMap.create();
    @GuardedBy(value="lock")
    private final SubpartitionSelector<ResultSubpartitionView> availableViews = new RoundRobinSubpartitionSelector<ResultSubpartitionView>();
    private final BufferAvailabilityListener availabilityListener;
    @GuardedBy(value="lock")
    private final Queue<Tuple2<ResultSubpartition.BufferAndBacklog, Integer>> cachedBuffers = new LinkedList<Tuple2<ResultSubpartition.BufferAndBacklog, Integer>>();
    @GuardedBy(value="lock")
    private final Set<ResultSubpartitionView> unregisteredAvailableViews = new HashSet<ResultSubpartitionView>();
    private final int numTotalViews;
    @GuardedBy(value="lock")
    private boolean isReleased;
    @GuardedBy(value="lock")
    private int sequenceNumber;

    public UnionResultSubpartitionView(BufferAvailabilityListener availabilityListener, int numTotalViews) {
        this.availabilityListener = availabilityListener;
        this.isReleased = false;
        this.sequenceNumber = 0;
        this.numTotalViews = numTotalViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewCreated(int subpartitionId, ResultSubpartitionView view) {
        Object object = this.lock;
        synchronized (object) {
            this.allViews.put(subpartitionId, view);
            if (this.allViews.size() == this.numTotalViews) {
                for (ResultSubpartitionView unregisteredAvailableView : this.unregisteredAvailableViews) {
                    this.notifyDataAvailable(unregisteredAvailableView);
                }
                this.unregisteredAvailableViews.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peekNextBufferSubpartitionId() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.cacheBuffer();
            return this.cachedBuffers.isEmpty() ? -1 : (Integer)this.cachedBuffers.peek().f1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.cacheBuffer();
            if (this.cachedBuffers.isEmpty()) {
                return null;
            }
            ResultSubpartition.BufferAndBacklog buffer = (ResultSubpartition.BufferAndBacklog)this.cachedBuffers.poll().f0;
            return new ResultSubpartition.BufferAndBacklog(buffer.buffer(), this.cachedBuffers.size(), this.cachedBuffers.isEmpty() ? Buffer.DataType.NONE : ((ResultSubpartition.BufferAndBacklog)this.cachedBuffers.peek().f0).buffer().getDataType(), this.sequenceNumber++);
        }
    }

    private void cacheBuffer() throws IOException {
        ResultSubpartitionView currentView;
        while (this.cachedBuffers.size() < 10 && (currentView = this.availableViews.getNextSubpartitionToConsume()) != null) {
            ResultSubpartition.BufferAndBacklog buffer = currentView.getNextBuffer();
            if (buffer == null) {
                this.availableViews.markLastConsumptionStatus(false, false);
                if (this.availableViews.isMoreSubpartitionSwitchable()) continue;
                break;
            }
            this.availableViews.markLastConsumptionStatus(true, buffer.buffer().getDataType().isPartialRecord());
            this.cachedBuffers.add(Tuple2.of(buffer, this.allViews.inverse().get(currentView)));
        }
    }

    @Override
    public void notifyDataAvailable() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataAvailable(ResultSubpartitionView view) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.allViews.containsValue(view)) {
                this.unregisteredAvailableViews.add(view);
                return;
            }
            if (!this.availableViews.notifyDataAvailable(view) || !this.cachedBuffers.isEmpty()) {
                return;
            }
            if (this.allViews.size() < this.numTotalViews) {
                return;
            }
            try {
                this.cacheBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.cachedBuffers.isEmpty()) {
                return;
            }
        }
        this.availabilityListener.notifyDataAvailable(this);
    }

    @Override
    public void notifyPriorityEvent(int priorityBufferNumber) {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllResources() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            for (ResultSubpartitionView resultSubpartitionView : this.allViews.values()) {
                resultSubpartitionView.releaseAllResources();
            }
            this.allViews.clear();
            for (ResultSubpartitionView resultSubpartitionView : this.unregisteredAvailableViews) {
                resultSubpartitionView.releaseAllResources();
            }
            this.unregisteredAvailableViews.clear();
            for (Tuple2 tuple2 : this.cachedBuffers) {
                ((ResultSubpartition.BufferAndBacklog)tuple2.f0).buffer().recycleBuffer();
            }
            this.cachedBuffers.clear();
            this.isReleased = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReleased() {
        Object object = this.lock;
        synchronized (object) {
            return this.isReleased;
        }
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public void acknowledgeAllDataProcessed() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable getFailureCause() {
        Throwable cause = null;
        Object object = this.lock;
        synchronized (object) {
            for (ResultSubpartitionView view : this.allViews.values()) {
                if (view.getFailureCause() == null) continue;
                cause = view.getFailureCause();
                LOG.error(cause.toString());
            }
        }
        return cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog(boolean isCreditAvailable) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.cacheBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.cachedBuffers.isEmpty()) {
                return new ResultSubpartitionView.AvailabilityWithBacklog(false, 0);
            }
            return new ResultSubpartitionView.AvailabilityWithBacklog(isCreditAvailable || ((ResultSubpartition.BufferAndBacklog)this.cachedBuffers.peek().f0).buffer().getDataType().isEvent(), (int)this.cachedBuffers.stream().filter(x -> ((ResultSubpartition.BufferAndBacklog)x.f0).buffer().getDataType().isBuffer()).count());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRequiredSegmentId(int subpartitionId, int segmentId) {
        Object object = this.lock;
        synchronized (object) {
            ((ResultSubpartitionView)this.allViews.get(subpartitionId)).notifyRequiredSegmentId(subpartitionId, segmentId);
        }
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return this.cachedBuffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfQueuedBuffers() {
        Object object = this.lock;
        synchronized (object) {
            return this.cachedBuffers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNewBufferSize(int newBufferSize) {
        Object object = this.lock;
        synchronized (object) {
            for (ResultSubpartitionView view : this.allViews.values()) {
                view.notifyNewBufferSize(newBufferSize);
            }
        }
    }
}

