/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.LinkedList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferWithSubpartition;
import org.apache.flink.runtime.io.network.partition.SortBuffer;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class SortBasedDataBuffer
extends SortBuffer {
    public SortBasedDataBuffer(LinkedList<MemorySegment> freeSegments, BufferRecycler bufferRecycler, int numSubpartitions, int bufferSize, int numGuaranteedBuffers, @Nullable int[] customReadOrder) {
        super(freeSegments, bufferRecycler, numSubpartitions, bufferSize, numGuaranteedBuffers, customReadOrder);
    }

    @Override
    public BufferWithSubpartition getNextBuffer(MemorySegment transitBuffer) {
        Preconditions.checkState(this.isFinished, "Sort buffer is not ready to be read.");
        Preconditions.checkState(!this.isReleased, "Sort buffer is already released.");
        if (!this.hasRemaining()) {
            return null;
        }
        int numBytesCopied = 0;
        Buffer.DataType bufferDataType = Buffer.DataType.DATA_BUFFER;
        int subpartitionIndex = this.subpartitionReadOrder[this.readOrderIndex];
        do {
            int sourceSegmentIndex = this.getSegmentIndexFromPointer(this.readIndexEntryAddress);
            int sourceSegmentOffset = this.getSegmentOffsetFromPointer(this.readIndexEntryAddress);
            MemorySegment sourceSegment = (MemorySegment)this.segments.get(sourceSegmentIndex);
            long lengthAndDataType = sourceSegment.getLong(sourceSegmentOffset);
            int length = this.getSegmentIndexFromPointer(lengthAndDataType);
            Buffer.DataType dataType = Buffer.DataType.values()[this.getSegmentOffsetFromPointer(lengthAndDataType)];
            if (dataType.isEvent() && numBytesCopied > 0) break;
            bufferDataType = dataType;
            long nextReadIndexEntryAddress = sourceSegment.getLong(sourceSegmentOffset + 8);
            sourceSegmentOffset += 16;
            if (bufferDataType.isEvent() && transitBuffer.size() < length) {
                transitBuffer = MemorySegmentFactory.allocateUnpooledSegment(length);
            }
            numBytesCopied += this.copyRecordOrEvent(transitBuffer, numBytesCopied, sourceSegmentIndex, sourceSegmentOffset, length);
            if (this.recordRemainingBytes != 0) continue;
            if (this.readIndexEntryAddress == this.lastIndexEntryAddresses[subpartitionIndex]) {
                this.updateReadSubpartitionAndIndexEntryAddress();
                break;
            }
            this.readIndexEntryAddress = nextReadIndexEntryAddress;
        } while (numBytesCopied < transitBuffer.size() && bufferDataType.isBuffer());
        this.numTotalBytesRead += (long)numBytesCopied;
        NetworkBuffer buffer = new NetworkBuffer(transitBuffer, buf -> {}, bufferDataType, numBytesCopied);
        return new BufferWithSubpartition(buffer, subpartitionIndex);
    }
}

