/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BoundedData;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.MemoryMappedBoundedData;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.shaded.netty4.io.netty.util.internal.PlatformDependent;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

final class FileChannelMemoryMappedBoundedData
implements BoundedData {
    private final FileChannel fileChannel;
    private final ByteBuffer[] headerAndBufferArray;
    private final ArrayList<ByteBuffer> memoryMappedRegions;
    private final Path filePath;
    private long pos;
    private long endOfCurrentRegion;
    private long startOfCurrentRegion;
    private final long maxRegionSize;

    FileChannelMemoryMappedBoundedData(Path filePath, FileChannel fileChannel, int maxSizePerMappedRegion) {
        this.filePath = filePath;
        this.fileChannel = fileChannel;
        this.headerAndBufferArray = BufferReaderWriterUtil.allocatedWriteBufferArray();
        this.memoryMappedRegions = new ArrayList(4);
        this.maxRegionSize = maxSizePerMappedRegion;
        this.endOfCurrentRegion = maxSizePerMappedRegion;
    }

    @Override
    public void writeBuffer(Buffer buffer) throws IOException {
        if (this.tryWriteBuffer(buffer)) {
            return;
        }
        this.mapRegionAndStartNext();
        if (!this.tryWriteBuffer(buffer)) {
            this.throwTooLargeBuffer(buffer);
        }
    }

    private boolean tryWriteBuffer(Buffer buffer) throws IOException {
        long spaceLeft = this.endOfCurrentRegion - this.pos;
        long bytesWritten = BufferReaderWriterUtil.writeToByteChannelIfBelowSize(this.fileChannel, buffer, this.headerAndBufferArray, spaceLeft);
        if (bytesWritten >= 0L) {
            this.pos += bytesWritten;
            return true;
        }
        return false;
    }

    @Override
    public BoundedData.Reader createReader(ResultSubpartitionView ignored) {
        Preconditions.checkState(!this.fileChannel.isOpen());
        List<ByteBuffer> buffers = this.memoryMappedRegions.stream().map(bb -> bb.duplicate().order(ByteOrder.nativeOrder())).collect(Collectors.toList());
        return new MemoryMappedBoundedData.BufferSlicer(buffers);
    }

    @Override
    public void finishWrite() throws IOException {
        this.mapRegionAndStartNext();
        this.fileChannel.close();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.fileChannel);
        for (ByteBuffer bb : this.memoryMappedRegions) {
            PlatformDependent.freeDirectBuffer(bb);
        }
        this.memoryMappedRegions.clear();
        Files.delete(this.filePath);
    }

    @Override
    public long getSize() {
        return this.pos;
    }

    @Override
    public Path getFilePath() {
        return this.filePath;
    }

    private void mapRegionAndStartNext() throws IOException {
        MappedByteBuffer region = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.startOfCurrentRegion, this.pos - this.startOfCurrentRegion);
        region.order(ByteOrder.nativeOrder());
        this.memoryMappedRegions.add(region);
        this.startOfCurrentRegion = this.pos;
        this.endOfCurrentRegion = this.startOfCurrentRegion + this.maxRegionSize;
    }

    private void throwTooLargeBuffer(Buffer buffer) throws IOException {
        throw new IOException(String.format("The buffer (%d bytes) is larger than the maximum size of a memory buffer (%d bytes)", buffer.getSize(), this.maxRegionSize));
    }

    public static FileChannelMemoryMappedBoundedData create(Path memMappedFilePath) throws IOException {
        return FileChannelMemoryMappedBoundedData.createWithRegionSize(memMappedFilePath, Integer.MAX_VALUE);
    }

    public static FileChannelMemoryMappedBoundedData createWithRegionSize(Path memMappedFilePath, int regionSize) throws IOException {
        Preconditions.checkNotNull(memMappedFilePath, "memMappedFilePath");
        Preconditions.checkArgument(regionSize > 0, "regions size most be > 0");
        FileChannel fileChannel = FileChannel.open(memMappedFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        return new FileChannelMemoryMappedBoundedData(memMappedFilePath, fileChannel, regionSize);
    }
}

