/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadsafeJobResultStore
implements JobResultStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThreadsafeJobResultStore.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Executor ioExecutor;

    protected AbstractThreadsafeJobResultStore(Executor ioExecutor) {
        this.ioExecutor = ioExecutor;
    }

    @Override
    public CompletableFuture<Void> createDirtyResultAsync(JobResultEntry jobResultEntry) {
        return ((CompletableFuture)this.hasJobResultEntryAsync(jobResultEntry.getJobId()).thenAccept(hasJobResultEntry -> Preconditions.checkState(hasJobResultEntry == false, "Job result store already contains an entry for job %s", jobResultEntry.getJobId()))).thenCompose(ignoredVoid -> this.withWriteLockAsync(() -> this.createDirtyResultInternal(jobResultEntry)));
    }

    @GuardedBy(value="readWriteLock")
    protected abstract void createDirtyResultInternal(JobResultEntry var1) throws IOException;

    @Override
    public CompletableFuture<Void> markResultAsCleanAsync(JobID jobId) {
        return this.hasCleanJobResultEntryAsync(jobId).thenCompose(hasCleanJobResultEntry -> {
            if (hasCleanJobResultEntry.booleanValue()) {
                LOG.debug("The job {} is already marked as clean. No action required.", (Object)jobId);
                return FutureUtils.completedVoidFuture();
            }
            return this.withWriteLockAsync(() -> this.markResultAsCleanInternal(jobId));
        });
    }

    @GuardedBy(value="readWriteLock")
    protected abstract void markResultAsCleanInternal(JobID var1) throws IOException, NoSuchElementException;

    @Override
    public CompletableFuture<Boolean> hasJobResultEntryAsync(JobID jobId) {
        return this.withReadLockAsync(() -> this.hasDirtyJobResultEntryInternal(jobId) || this.hasCleanJobResultEntryInternal(jobId));
    }

    @Override
    public CompletableFuture<Boolean> hasDirtyJobResultEntryAsync(JobID jobId) {
        return this.withReadLockAsync(() -> this.hasDirtyJobResultEntryInternal(jobId));
    }

    @GuardedBy(value="readWriteLock")
    protected abstract boolean hasDirtyJobResultEntryInternal(JobID var1) throws IOException;

    @Override
    public CompletableFuture<Boolean> hasCleanJobResultEntryAsync(JobID jobId) {
        return this.withReadLockAsync(() -> this.hasCleanJobResultEntryInternal(jobId));
    }

    @GuardedBy(value="readWriteLock")
    protected abstract boolean hasCleanJobResultEntryInternal(JobID var1) throws IOException;

    @Override
    public Set<JobResult> getDirtyResults() throws IOException {
        return this.withReadLock(this::getDirtyResultsInternal);
    }

    @GuardedBy(value="readWriteLock")
    protected abstract Set<JobResult> getDirtyResultsInternal() throws IOException;

    private CompletableFuture<Void> withWriteLockAsync(ThrowingRunnable<IOException> runnable) {
        return FutureUtils.runAsync(() -> this.withWriteLock(runnable), this.ioExecutor);
    }

    private void withWriteLock(ThrowingRunnable<IOException> runnable) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private <T> CompletableFuture<T> withReadLockAsync(SupplierWithException<T, IOException> runnable) {
        return FutureUtils.supplyAsync(() -> this.withReadLock(runnable), this.ioExecutor);
    }

    private <T> T withReadLock(SupplierWithException<T, IOException> supplier) throws IOException {
        this.readWriteLock.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

