/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.filemerging.AcrossCheckpointFileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingType;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFilePool;
import org.apache.flink.runtime.checkpoint.filemerging.WithinCheckpointFileMergingSnapshotManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.util.Preconditions;

public class FileMergingSnapshotManagerBuilder {
    private static final String ID_FORMAT = "job_%s_tm_%s";
    private final JobID jobId;
    private final ResourceID tmResourceId;
    private final FileMergingType fileMergingType;
    private long maxFileSize = 0x2000000L;
    private PhysicalFilePool.Type filePoolType = PhysicalFilePool.Type.NON_BLOCKING;
    private float maxSpaceAmplification = Float.MAX_VALUE;
    @Nullable
    private Executor ioExecutor = null;
    @Nullable
    private TaskManagerJobMetricGroup metricGroup;

    public FileMergingSnapshotManagerBuilder(JobID jobId, ResourceID tmResourceId, FileMergingType type) {
        this.jobId = jobId;
        this.tmResourceId = tmResourceId;
        this.fileMergingType = type;
    }

    public FileMergingSnapshotManagerBuilder setMaxFileSize(long maxFileSize) {
        Preconditions.checkArgument(maxFileSize > 0L);
        this.maxFileSize = maxFileSize;
        return this;
    }

    public FileMergingSnapshotManagerBuilder setFilePoolType(PhysicalFilePool.Type filePoolType) {
        this.filePoolType = filePoolType;
        return this;
    }

    public FileMergingSnapshotManagerBuilder setMaxSpaceAmplification(float amplification) {
        this.maxSpaceAmplification = amplification < 1.0f ? Float.MAX_VALUE : amplification;
        return this;
    }

    public FileMergingSnapshotManagerBuilder setIOExecutor(@Nullable Executor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    public FileMergingSnapshotManagerBuilder setMetricGroup(TaskManagerJobMetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        return this;
    }

    public FileMergingSnapshotManager build() {
        switch (this.fileMergingType) {
            case MERGE_WITHIN_CHECKPOINT: {
                return new WithinCheckpointFileMergingSnapshotManager(String.format(ID_FORMAT, this.jobId, this.tmResourceId), this.maxFileSize, this.filePoolType, this.maxSpaceAmplification, this.ioExecutor == null ? Runnable::run : this.ioExecutor, this.metricGroup == null ? new UnregisteredMetricGroups.UnregisteredTaskManagerJobMetricGroup() : this.metricGroup);
            }
            case MERGE_ACROSS_CHECKPOINT: {
                return new AcrossCheckpointFileMergingSnapshotManager(String.format(ID_FORMAT, this.jobId, this.tmResourceId), this.maxFileSize, this.filePoolType, this.maxSpaceAmplification, this.ioExecutor == null ? Runnable::run : this.ioExecutor, this.metricGroup == null ? new UnregisteredMetricGroups.UnregisteredTaskManagerJobMetricGroup() : this.metricGroup);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported type %s when creating file merging manager", new Object[]{this.fileMergingType}));
    }
}

