/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import org.apache.flink.core.state.StateFutureImpl;
import org.apache.flink.runtime.asyncprocessing.RecordContext;

public class ContextStateFutureImpl<T>
extends StateFutureImpl<T> {
    private final RecordContext<?> recordContext;

    ContextStateFutureImpl(StateFutureImpl.CallbackRunner callbackRunner, StateFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler, RecordContext<?> recordContext) {
        super(callbackRunner, exceptionHandler);
        this.recordContext = recordContext;
        recordContext.retain();
    }

    @Override
    public <A> StateFutureImpl<A> makeNewStateFuture() {
        return new ContextStateFutureImpl<T>(this.callbackRunner, this.exceptionHandler, this.recordContext);
    }

    @Override
    public void callbackRegistered() {
        this.recordContext.retain();
    }

    @Override
    public void postComplete(boolean inCallbackRunner) {
        if (inCallbackRunner) {
            this.recordContext.release(Runnable::run);
        } else {
            this.recordContext.release(runnable -> {
                try {
                    this.callbackRunner.submit(runnable::run);
                }
                catch (Exception e) {
                    this.exceptionHandler.handleException("Caught exception when post complete StateFuture.", e);
                }
            });
        }
    }

    @Override
    public void callbackFinished() {
        this.recordContext.release(Runnable::run);
    }
}

