/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.application.ApplicationDispatcherBootstrap;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServices;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServicesWithJobPersistenceComponents;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.dispatcher.runner.DefaultDispatcherGatewayService;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Internal
public class ApplicationDispatcherGatewayServiceFactory
implements AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory {
    private final Configuration configuration;
    private final DispatcherFactory dispatcherFactory;
    private final PackagedProgram application;
    private final RpcService rpcService;
    private final PartialDispatcherServices partialDispatcherServices;

    public ApplicationDispatcherGatewayServiceFactory(Configuration configuration, DispatcherFactory dispatcherFactory, PackagedProgram application, RpcService rpcService, PartialDispatcherServices partialDispatcherServices) {
        this.configuration = configuration;
        this.dispatcherFactory = dispatcherFactory;
        this.application = Preconditions.checkNotNull(application);
        this.rpcService = rpcService;
        this.partialDispatcherServices = partialDispatcherServices;
    }

    @Override
    public AbstractDispatcherLeaderProcess.DispatcherGatewayService create(DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, Collection<JobResult> recoveredDirtyJobResults, JobGraphWriter jobGraphWriter, JobResultStore jobResultStore) {
        Dispatcher dispatcher;
        List<JobID> recoveredJobIds = this.getRecoveredJobIds(recoveredJobs);
        try {
            dispatcher = this.dispatcherFactory.createDispatcher(this.rpcService, fencingToken, recoveredJobs, recoveredDirtyJobResults, (dispatcherGateway, scheduledExecutor, errorHandler) -> new ApplicationDispatcherBootstrap(this.application, recoveredJobIds, this.configuration, dispatcherGateway, scheduledExecutor, errorHandler), PartialDispatcherServicesWithJobPersistenceComponents.from(this.partialDispatcherServices, jobGraphWriter, jobResultStore));
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Could not create the Dispatcher rpc endpoint.", e);
        }
        dispatcher.start();
        return DefaultDispatcherGatewayService.from(dispatcher);
    }

    private List<JobID> getRecoveredJobIds(Collection<JobGraph> recoveredJobs) {
        return recoveredJobs.stream().map(JobGraph::getJobID).collect(Collectors.toList());
    }
}

