/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class DeclarativeAggregateFunction
extends UserDefinedFunction {
    private transient Set<String> aggBufferNamesCache;

    public abstract int operandCount();

    public abstract UnresolvedReferenceExpression[] aggBufferAttributes();

    public abstract DataType[] getAggBufferTypes();

    public abstract DataType getResultType();

    public abstract Expression[] initialValuesExpressions();

    public abstract Expression[] accumulateExpressions();

    public abstract Expression[] retractExpressions();

    public abstract Expression[] mergeExpressions();

    public abstract Expression getValueExpression();

    private Set<String> getAggBufferNames() {
        if (this.aggBufferNamesCache == null) {
            this.aggBufferNamesCache = Arrays.stream(this.aggBufferAttributes()).map(UnresolvedReferenceExpression::getName).collect(Collectors.toSet());
        }
        return this.aggBufferNamesCache;
    }

    private void validateOperandName(String name) {
        if (this.getAggBufferNames().contains(name)) {
            throw new IllegalStateException(String.format("Agg buffer name(%s) should not same to operands.", name));
        }
    }

    public final UnresolvedReferenceExpression[] operands() {
        int operandCount = this.operandCount();
        Preconditions.checkState(operandCount >= 0, "inputCount must be greater than or equal to 0.");
        UnresolvedReferenceExpression[] ret = new UnresolvedReferenceExpression[operandCount];
        for (int i = 0; i < operandCount; ++i) {
            String name = String.valueOf(i);
            this.validateOperandName(name);
            ret[i] = ApiExpressionUtils.unresolvedRef(name);
        }
        return ret;
    }

    public final UnresolvedReferenceExpression operand(int i) {
        String name = String.valueOf(i);
        if (this.getAggBufferNames().contains(name)) {
            throw new IllegalStateException(String.format("Agg buffer name(%s) should not same to operands.", name));
        }
        return ApiExpressionUtils.unresolvedRef(name);
    }

    public final UnresolvedReferenceExpression mergeOperand(UnresolvedReferenceExpression aggBuffer) {
        String name = String.valueOf(Arrays.asList(this.aggBufferAttributes()).indexOf(aggBuffer));
        this.validateOperandName(name);
        return ApiExpressionUtils.unresolvedRef(name);
    }

    public final UnresolvedReferenceExpression[] mergeOperands() {
        UnresolvedReferenceExpression[] aggBuffers = this.aggBufferAttributes();
        UnresolvedReferenceExpression[] ret = new UnresolvedReferenceExpression[aggBuffers.length];
        for (int i = 0; i < aggBuffers.length; ++i) {
            String name = String.valueOf(i);
            this.validateOperandName(name);
            ret[i] = ApiExpressionUtils.unresolvedRef(name);
        }
        return ret;
    }

    @Override
    public FunctionKind getKind() {
        return FunctionKind.OTHER;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory factory) {
        throw new UnsupportedOperationException();
    }
}

