/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.BackendBuildingException;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackendBuilder;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateBackend;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageAccess;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackendBuilder;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;
import org.slf4j.LoggerFactory;

@Deprecated
@PublicEvolving
public class FsStateBackend
extends AbstractFileStateBackend
implements ConfigurableStateBackend {
    private static final long serialVersionUID = -8191916350224044011L;
    private static final int MAX_FILE_STATE_THRESHOLD = 0x100000;
    private final int fileStateThreshold;
    private final int writeBufferSize;
    private boolean createCheckpointSubDirs;

    public FsStateBackend(String checkpointDataUri) {
        this(new Path(checkpointDataUri));
    }

    public FsStateBackend(String checkpointDataUri, boolean asynchronousSnapshots) {
        this(new Path(checkpointDataUri), asynchronousSnapshots);
    }

    public FsStateBackend(Path checkpointDataUri) {
        this(checkpointDataUri.toUri());
    }

    public FsStateBackend(Path checkpointDataUri, boolean asynchronousSnapshots) {
        this(checkpointDataUri.toUri(), asynchronousSnapshots);
    }

    public FsStateBackend(URI checkpointDataUri) {
        this(checkpointDataUri, null, -1, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, @Nullable URI defaultSavepointDirectory) {
        this(checkpointDataUri, defaultSavepointDirectory, -1, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, boolean asynchronousSnapshots) {
        this(checkpointDataUri, null, -1, -1, TernaryBoolean.fromBoolean(asynchronousSnapshots));
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold) {
        this(checkpointDataUri, null, fileStateSizeThreshold, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold, boolean asynchronousSnapshots) {
        this(checkpointDataUri, null, fileStateSizeThreshold, -1, TernaryBoolean.fromBoolean(asynchronousSnapshots));
    }

    public FsStateBackend(URI checkpointDirectory, @Nullable URI defaultSavepointDirectory, int fileStateSizeThreshold, int writeBufferSize, TernaryBoolean asynchronousSnapshots) {
        super(Preconditions.checkNotNull(checkpointDirectory, "checkpoint directory is null"), defaultSavepointDirectory);
        Preconditions.checkArgument(fileStateSizeThreshold >= -1 && fileStateSizeThreshold <= 0x100000, "The threshold for file state size must be in [-1, %s], where '-1' means to use the value from the deployment's configuration.", 0x100000);
        Preconditions.checkArgument(writeBufferSize >= -1, "The write buffer size must be not less than '-1', where '-1' means to use the value from the deployment's configuration.");
        this.fileStateThreshold = fileStateSizeThreshold;
        this.writeBufferSize = writeBufferSize;
        this.createCheckpointSubDirs = CheckpointingOptions.CREATE_CHECKPOINT_SUB_DIR.defaultValue();
    }

    private FsStateBackend(FsStateBackend original, ReadableConfig configuration, ClassLoader classLoader) {
        super(original.getCheckpointPath(), original.getSavepointPath(), configuration);
        if (this.getValidFileStateThreshold(original.fileStateThreshold) >= 0) {
            this.fileStateThreshold = original.fileStateThreshold;
        } else {
            int configuredStateThreshold = this.getValidFileStateThreshold(configuration.get(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD).getBytes());
            if (configuredStateThreshold >= 0) {
                this.fileStateThreshold = configuredStateThreshold;
            } else {
                this.fileStateThreshold = MathUtils.checkedDownCast(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue().getBytes());
                LoggerFactory.getLogger(AbstractFileStateBackend.class).warn("Ignoring invalid file size threshold value ({}): {} - using default value {} instead.", new Object[]{CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.key(), configuration.get(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD).getBytes(), CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue()});
            }
        }
        int bufferSize = original.writeBufferSize >= 0 ? original.writeBufferSize : configuration.get(CheckpointingOptions.FS_WRITE_BUFFER_SIZE);
        this.writeBufferSize = Math.max(bufferSize, this.fileStateThreshold);
        this.createCheckpointSubDirs = configuration.getOptional(CheckpointingOptions.CREATE_CHECKPOINT_SUB_DIR).orElse(original.createCheckpointSubDirs);
        this.latencyTrackingConfigBuilder = original.latencyTrackingConfigBuilder.configure(configuration);
    }

    private int getValidFileStateThreshold(long fileStateThreshold) {
        if (fileStateThreshold >= 0L && fileStateThreshold <= 0x100000L) {
            return (int)fileStateThreshold;
        }
        return -1;
    }

    @Deprecated
    public Path getBasePath() {
        return this.getCheckpointPath();
    }

    @Override
    @Nonnull
    public Path getCheckpointPath() {
        return super.getCheckpointPath();
    }

    public int getMinFileSizeThreshold() {
        return this.fileStateThreshold >= 0 ? this.fileStateThreshold : MathUtils.checkedDownCast(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue().getBytes());
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize >= 0 ? this.writeBufferSize : CheckpointingOptions.FS_WRITE_BUFFER_SIZE.defaultValue();
    }

    public boolean isUsingAsynchronousSnapshots() {
        return true;
    }

    @Override
    public boolean supportsNoClaimRestoreMode() {
        return true;
    }

    @Override
    public boolean supportsSavepointFormat(SavepointFormatType formatType) {
        return true;
    }

    @Override
    public FsStateBackend configure(ReadableConfig config, ClassLoader classLoader) {
        return new FsStateBackend(this, config, classLoader);
    }

    @Override
    public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        return new FsCheckpointStorageAccess(this.getCheckpointPath(), this.getSavepointPath(), this.createCheckpointSubDirs, jobId, this.getMinFileSizeThreshold(), this.getWriteBufferSize());
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) throws BackendBuildingException {
        TaskStateManager taskStateManager = parameters.getEnv().getTaskStateManager();
        LocalRecoveryConfig localRecoveryConfig = taskStateManager.createLocalRecoveryConfig();
        HeapPriorityQueueSetFactory priorityQueueSetFactory = new HeapPriorityQueueSetFactory(parameters.getKeyGroupRange(), parameters.getNumberOfKeyGroups(), 128);
        LatencyTrackingStateConfig latencyTrackingStateConfig = this.latencyTrackingConfigBuilder.setMetricGroup(parameters.getMetricGroup()).build();
        return new HeapKeyedStateBackendBuilder<K>(parameters.getKvStateRegistry(), parameters.getKeySerializer(), parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getNumberOfKeyGroups(), parameters.getKeyGroupRange(), parameters.getEnv().getExecutionConfig(), parameters.getTtlTimeProvider(), latencyTrackingStateConfig, parameters.getStateHandles(), AbstractStateBackend.getCompressionDecorator(parameters.getEnv().getExecutionConfig()), localRecoveryConfig, priorityQueueSetFactory, this.isUsingAsynchronousSnapshots(), parameters.getCancelStreamRegistry()).build();
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) throws BackendBuildingException {
        return new DefaultOperatorStateBackendBuilder(parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getEnv().getExecutionConfig(), this.isUsingAsynchronousSnapshots(), parameters.getStateHandles(), parameters.getCancelStreamRegistry()).build();
    }

    public String toString() {
        return "File State Backend (checkpoints: '" + this.getCheckpointPath() + "', savepoints: '" + this.getSavepointPath() + ", fileStateThreshold: " + this.fileStateThreshold + ")";
    }
}

