/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;

@Internal
public class KeyedStateBackendParametersImpl<K>
implements StateBackend.KeyedStateBackendParameters<K> {
    private final Environment env;
    private final JobID jobID;
    private final String operatorIdentifier;
    private final TypeSerializer<K> keySerializer;
    private final int numberOfKeyGroups;
    private final KeyGroupRange keyGroupRange;
    private final TaskKvStateRegistry kvStateRegistry;
    private TtlTimeProvider ttlTimeProvider;
    private final MetricGroup metricGroup;
    private final StateBackend.CustomInitializationMetrics customInitializationMetrics;
    private Collection<KeyedStateHandle> stateHandles;
    private final CloseableRegistry cancelStreamRegistry;
    private final double managedMemoryFraction;

    public KeyedStateBackendParametersImpl(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) {
        this(env, jobID, operatorIdentifier, keySerializer, numberOfKeyGroups, keyGroupRange, kvStateRegistry, ttlTimeProvider, metricGroup, (name, value) -> {}, stateHandles, cancelStreamRegistry, 1.0);
    }

    public KeyedStateBackendParametersImpl(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, StateBackend.CustomInitializationMetrics customInitializationMetrics, Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry, double managedMemoryFraction) {
        this.env = env;
        this.jobID = jobID;
        this.operatorIdentifier = operatorIdentifier;
        this.keySerializer = keySerializer;
        this.numberOfKeyGroups = numberOfKeyGroups;
        this.keyGroupRange = keyGroupRange;
        this.kvStateRegistry = kvStateRegistry;
        this.ttlTimeProvider = ttlTimeProvider;
        this.metricGroup = metricGroup;
        this.customInitializationMetrics = customInitializationMetrics;
        this.stateHandles = stateHandles;
        this.cancelStreamRegistry = cancelStreamRegistry;
        this.managedMemoryFraction = managedMemoryFraction;
    }

    public KeyedStateBackendParametersImpl(StateBackend.KeyedStateBackendParameters<K> parameters) {
        this(parameters.getEnv(), parameters.getJobID(), parameters.getOperatorIdentifier(), parameters.getKeySerializer(), parameters.getNumberOfKeyGroups(), parameters.getKeyGroupRange(), parameters.getKvStateRegistry(), parameters.getTtlTimeProvider(), parameters.getMetricGroup(), parameters.getCustomInitializationMetrics(), parameters.getStateHandles(), parameters.getCancelStreamRegistry(), parameters.getManagedMemoryFraction());
    }

    @Override
    public Environment getEnv() {
        return this.env;
    }

    @Override
    public JobID getJobID() {
        return this.jobID;
    }

    @Override
    public String getOperatorIdentifier() {
        return this.operatorIdentifier;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public int getNumberOfKeyGroups() {
        return this.numberOfKeyGroups;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public TaskKvStateRegistry getKvStateRegistry() {
        return this.kvStateRegistry;
    }

    @Override
    public TtlTimeProvider getTtlTimeProvider() {
        return this.ttlTimeProvider;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    @Nonnull
    public Collection<KeyedStateHandle> getStateHandles() {
        return this.stateHandles;
    }

    @Override
    public CloseableRegistry getCancelStreamRegistry() {
        return this.cancelStreamRegistry;
    }

    @Override
    public double getManagedMemoryFraction() {
        return this.managedMemoryFraction;
    }

    @Override
    public StateBackend.CustomInitializationMetrics getCustomInitializationMetrics() {
        return this.customInitializationMetrics;
    }

    public KeyedStateBackendParametersImpl<K> setStateHandles(Collection<KeyedStateHandle> stateHandles) {
        this.stateHandles = stateHandles;
        return this;
    }

    public KeyedStateBackendParametersImpl<K> setTtlTimeProvider(TtlTimeProvider ttlTimeProvider) {
        this.ttlTimeProvider = ttlTimeProvider;
        return this;
    }
}

